/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.DefaultLintQuickFix;
import com.android.tools.lint.checks.SupportAnnotationDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLintCheckResultInspection
extends AndroidLintInspectionBase {
    public AndroidLintCheckResultInspection() {
        super(AndroidBundle.message("android.lint.inspections.check.result", new Object[0]), SupportAnnotationDetector.CHECK_RESULT);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message, @Nullable LintFix fixData) {
        String suggest = (String)LintFix.getData((LintFix)fixData, String.class);
        if (suggest != null) {
            return new AndroidLintQuickFix[]{new ReplaceCallFix(suggest)};
        }
        return super.getQuickFixes(startElement, endElement, message, fixData);
    }

    static class ReplaceCallFix
    extends DefaultLintQuickFix {
        private final String mySuggest;

        public ReplaceCallFix(@NotNull String suggest) {
            super(null);
            this.mySuggest = suggest;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            return String.format("Call %1$s instead", this.getMethodName());
        }

        private String getMethodName() {
            assert (this.mySuggest.startsWith("#"));
            int start = 1;
            int parameters = this.mySuggest.indexOf(40, start);
            if (parameters == -1) {
                parameters = this.mySuggest.length();
            }
            return this.mySuggest.substring(start, parameters).trim();
        }

        @Override
        public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
            TextRange range;
            PsiReferenceExpression methodExpression;
            PsiElement referenceNameElement;
            if (!startElement.isValid()) {
                return;
            }
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiMethodCallExpression.class, (boolean)false);
            if (methodCall == null) {
                return;
            }
            PsiFile file = methodCall.getContainingFile();
            if (file == null) {
                return;
            }
            Document document = FileDocumentManager.getInstance().getDocument(file.getVirtualFile());
            if (document != null && (referenceNameElement = (methodExpression = methodCall.getMethodExpression()).getReferenceNameElement()) != null && (range = referenceNameElement.getTextRange()) != null) {
                String name = this.getMethodName();
                if (name.startsWith("enforce") && methodExpression.getReferenceName() != null && methodExpression.getReferenceName().startsWith("check")) {
                    PsiExpressionList argumentList = methodCall.getArgumentList();
                    int offset = argumentList.getTextOffset() + argumentList.getTextLength() - 1;
                    document.insertString(offset, (CharSequence)", \"TODO: message if thrown\"");
                }
                document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)name);
            }
        }
    }
}

