/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.lint.DefaultLintQuickFix;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.android.tools.idea.templates.SupportLibrary;
import com.android.tools.lint.checks.ExifInterfaceDetector;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class AndroidLintExifInterfaceInspection
extends AndroidLintInspectionBase {
    public static final String NEW_EXIT_INTERFACE = "android.support.media.ExifInterface";

    public AndroidLintExifInterfaceInspection() {
        super(AndroidBundle.message("android.lint.inspections.exif.interface", new Object[0]), ExifInterfaceDetector.ISSUE);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
        return new AndroidLintQuickFix[]{new ReplaceExifFix()};
    }

    private static class ReplaceExifFix
    extends DefaultLintQuickFix {
        public ReplaceExifFix() {
            super("Update all references in this file");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void apply(final @NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
            final Module module = AndroidPsiUtils.getModuleSafely(startElement);
            if (module != null) {
                LocalHistoryAction action = LocalHistory.getInstance().startAction(this.getName());
                final Project project = module.getProject();
                PsiClass cls = JavaPsiFacade.getInstance((Project)project).findClass(AndroidLintExifInterfaceInspection.NEW_EXIT_INTERFACE, GlobalSearchScope.allScope((Project)project));
                if (cls != null) {
                    this.replaceReferences(startElement);
                    return;
                }
                GradleBuildModel buildModel = GradleBuildModel.get(module);
                try {
                    if (buildModel == null) {
                        this.replaceReferences(startElement);
                    } else {
                        new WriteCommandAction(module.getProject(), this.getName(), new PsiFile[0]){

                            protected void run(@NotNull Result result) throws Throwable {
                                String libraryCoordinate = ReplaceExifFix.getExifLibraryCoordinate();
                                if (libraryCoordinate != null) {
                                    ModuleRootModificationUtil.updateModel((Module)module, model -> {
                                        GradleBuildModel buildModel = GradleBuildModel.get(module);
                                        if (buildModel != null) {
                                            String name = GradleUtil.mapConfigurationName("compile", GradleUtil.getAndroidGradleModelVersionInUse(module), false);
                                            buildModel.dependencies().addArtifact(name, libraryCoordinate);
                                            buildModel.applyChanges();
                                        }
                                    });
                                }
                                GradleSyncInvoker.Request request = new GradleSyncInvoker.Request().setGenerateSourcesOnSuccess(false).setTrigger(GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED);
                                GradleSyncInvoker.getInstance().requestProjectSync(project, request, new GradleSyncListener.Adapter(){

                                    @Override
                                    public void syncSucceeded(@NotNull Project project) {
                                        DumbService.getInstance((Project)project).runWhenSmart(() -> this.replaceReferences(startElement));
                                    }
                                });
                            }
                        }.execute();
                    }
                }
                finally {
                    action.finish();
                }
            }
        }

        private static String getExifLibraryCoordinate() {
            GradleVersion version;
            GradleCoordinate coordinate;
            RepositoryUrlManager manager = RepositoryUrlManager.get();
            String libraryCoordinate = manager.getLibraryStringCoordinate(SupportLibrary.EXIF_INTERFACE, true);
            if (libraryCoordinate != null && (coordinate = GradleCoordinate.parseCoordinateString((String)libraryCoordinate)) != null && (version = GradleVersion.tryParse((String)coordinate.getRevision())) != null && !version.isAtLeast(25, 1, 0)) {
                libraryCoordinate = coordinate.getGroupId() + ':' + coordinate.getArtifactId() + ":25.1.0";
            }
            return libraryCoordinate;
        }

        private void replaceReferences(final @NotNull PsiElement element) {
            new WriteCommandAction(element.getProject(), this.getName(), new PsiFile[0]){

                protected void run(@NotNull Result result) throws Throwable {
                    Project project = element.getProject();
                    final PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
                    final PsiClass cls = JavaPsiFacade.getInstance((Project)project).findClass(AndroidLintExifInterfaceInspection.NEW_EXIT_INTERFACE, GlobalSearchScope.allScope((Project)project));
                    PsiFile file = element.getContainingFile();
                    file.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                        public void visitReferenceElement(PsiJavaCodeReferenceElement expression) {
                            if ("ExifInterface".equals(expression.getReferenceName()) && expression.isQualified()) {
                                PsiElement context = expression.getParent();
                                if (expression instanceof PsiReferenceExpression) {
                                    if (cls != null) {
                                        PsiReferenceExpression replacement = factory.createReferenceExpression(cls);
                                        expression.replace((PsiElement)replacement);
                                        return;
                                    }
                                } else {
                                    expression.replace((PsiElement)factory.createReferenceFromText(AndroidLintExifInterfaceInspection.NEW_EXIT_INTERFACE, context));
                                    return;
                                }
                            }
                            super.visitReferenceElement(expression);
                        }
                    });
                }
            }.execute();
        }
    }
}

