/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.lint.ReplaceStringQuickFix;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.intellij.psi.PsiElement;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLintGradleDynamicVersionInspection
extends AndroidLintInspectionBase {
    public AndroidLintGradleDynamicVersionInspection() {
        super(AndroidBundle.message("android.lint.inspections.gradle.dynamic.version", new Object[0]), GradleDetector.PLUS);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(final @NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message, @Nullable LintFix fixData) {
        final GradleCoordinate plus = (GradleCoordinate)LintFix.getData((LintFix)fixData, GradleCoordinate.class);
        if (plus != null && plus.getArtifactId() != null) {
            return new AndroidLintQuickFix[]{new ReplaceStringQuickFix("Replace with specific version", plus.getRevision(), "specific version"){

                @Override
                @Nullable
                protected String getNewValue() {
                    return RepositoryUrlManager.get().resolveDynamicCoordinateVersion(plus, startElement.getProject());
                }
            }};
        }
        return super.getQuickFixes(startElement, endElement, message, fixData);
    }
}

