/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.ReplaceStringQuickFix;
import com.android.tools.lint.checks.AndroidAutoDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import java.util.ArrayList;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLintInvalidUsesTagAttributeInspection
extends AndroidLintInspectionBase {
    public AndroidLintInvalidUsesTagAttributeInspection() {
        super(AndroidBundle.message("android.lint.inspections.invalid.uses.tag.attribute", new Object[0]), AndroidAutoDetector.INVALID_USES_TAG_ISSUE);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message, @Nullable LintFix fixData) {
        XmlAttributeValue attributeValue;
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlAttribute.class);
        XmlAttributeValue xmlAttributeValue = attributeValue = attribute == null ? null : attribute.getValueElement();
        if (attributeValue != null && attributeValue.getTextLength() != 0) {
            String value = StringUtil.unquoteString((String)attributeValue.getText());
            String regexp = "(" + value + ")";
            String[] suggestions = AndroidAutoDetector.getAllowedAutomotiveAppTypes();
            ArrayList fixes = Lists.newArrayListWithExpectedSize((int)suggestions.length);
            for (String suggestion : suggestions) {
                fixes.add(new ReplaceStringQuickFix("Replace with \"" + suggestion + "\"", regexp, suggestion));
            }
            return fixes.toArray(new AndroidLintQuickFix[fixes.size()]);
        }
        return super.getQuickFixes(startElement, endElement, message, fixData);
    }
}

