/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.DefaultLintQuickFix;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintBaseline;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.TextFormat;
import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLintLintBaselineInspection
extends AndroidLintInspectionBase {
    public static boolean ourSkipBaselineNextRun;
    public static boolean ourUpdateBaselineNextRun;
    public static AnalysisScope ourRerunScope;

    public AndroidLintLintBaselineInspection() {
        super(AndroidBundle.message("android.lint.inspections.lint.baseline", new Object[0]), IssueRegistry.BASELINE);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message, @Nullable LintFix fixData) {
        if (LintBaseline.isFilteredMessage((String)message, (TextFormat)TextFormat.RAW)) {
            return new AndroidLintQuickFix[]{new DefaultLintQuickFix("Temporarily turn off the baseline and re-run the analysis"){

                @Override
                public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
                    ourSkipBaselineNextRun = true;
                    AndroidLintLintBaselineInspection.rerun();
                }
            }};
        }
        if (LintBaseline.isFixedMessage((String)message, (TextFormat)TextFormat.RAW)) {
            return new AndroidLintQuickFix[]{new DefaultLintQuickFix("Update baseline file to remove fixed issues"){

                @Override
                public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
                    ourUpdateBaselineNextRun = true;
                    AndroidLintLintBaselineInspection.rerun();
                }
            }};
        }
        return super.getQuickFixes(startElement, endElement, message, fixData);
    }

    private static void rerun() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ApplicationManager.getApplication().runWriteAction(() -> {
            for (Frame frame : Frame.getFrames()) {
                InspectionResultsView view = AndroidLintLintBaselineInspection.findInspectionView(frame);
                if (view == null || !view.isRerunAvailable() || view.isDisposed()) continue;
                ourRerunScope = view.getScope();
                view.rerun();
            }
        });
    }

    public static void clearNextRunState() {
        ourSkipBaselineNextRun = false;
        ourUpdateBaselineNextRun = false;
        ourRerunScope = null;
    }

    private static InspectionResultsView findInspectionView(Container container) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            InspectionResultsView view;
            Component component2 = container.getComponent(i);
            if (component2 instanceof InspectionResultsView) {
                return (InspectionResultsView)component2;
            }
            if (!(component2 instanceof Container) || (view = AndroidLintLintBaselineInspection.findInspectionView((Container)component2)) == null) continue;
            return view;
        }
        return null;
    }
}

