/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.DefaultLintQuickFix;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.lint.checks.PermissionRequirement;
import com.android.tools.lint.checks.SupportAnnotationDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AndroidLintMissingPermissionInspection
extends AndroidLintInspectionBase {
    public AndroidLintMissingPermissionInspection() {
        super(AndroidBundle.message("android.lint.inspections.missing.permission", new Object[0]), SupportAnnotationDetector.MISSING_PERMISSION);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message, LintFix quickfixData) {
        if (quickfixData instanceof LintFix.DataMap) {
            LintFix.DataMap map = (LintFix.DataMap)quickfixData;
            Set names = (Set)map.get(Set.class);
            if (names == null) {
                return super.getQuickFixes(startElement, endElement, message, quickfixData);
            }
            AndroidFacet facet = AndroidFacet.getInstance(startElement);
            if (facet == null) {
                return super.getQuickFixes(startElement, endElement, message, quickfixData);
            }
            Integer lastApplicableApi = (Integer)map.get(Integer.class);
            PermissionRequirement requirement = (PermissionRequirement)map.get(PermissionRequirement.class);
            if (lastApplicableApi != null) {
                ArrayList fixes = Lists.newArrayListWithExpectedSize((int)4);
                for (String name : names) {
                    fixes.add(new AddPermissionFix(facet, name, lastApplicableApi));
                }
                return fixes.toArray(AndroidLintQuickFix.EMPTY_ARRAY);
            }
            if (requirement != null) {
                return new AndroidLintQuickFix[]{new AddCheckPermissionFix(facet, requirement, startElement, names)};
            }
        }
        return super.getQuickFixes(startElement, endElement, message, quickfixData);
    }

    private static class AddCheckPermissionFix
    extends DefaultLintQuickFix {
        private final AndroidFacet myFacet;
        private final PermissionRequirement myRequirement;
        private final Set<String> myRevocablePermissions;
        private final SmartPsiElementPointer<PsiElement> myCall;

        public AddCheckPermissionFix(@NotNull AndroidFacet facet, @NotNull PermissionRequirement requirement, @NotNull PsiElement call, @NotNull Set<String> revocablePermissions) {
            super("Add permission check");
            this.myFacet = facet;
            this.myRequirement = requirement;
            this.myCall = SmartPointerManager.getInstance((Project)call.getProject()).createSmartPsiElementPointer(call);
            this.myRevocablePermissions = revocablePermissions;
        }

        @Override
        public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
            boolean usingAppCompat;
            IElementType operator;
            HashMap permissionNames;
            GlobalSearchScope moduleScope;
            Project project = this.myFacet.getModule().getProject();
            PsiElement call = this.myCall.getElement();
            if (call == null) {
                return;
            }
            PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)call, PsiStatement.class, (boolean)true);
            if (statement == null) {
                return;
            }
            PsiElement parent = statement.getParent();
            if (parent == null) {
                return;
            }
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
            PsiClass manifest = facade.findClass("android.Manifest.permission", moduleScope = GlobalSearchScope.moduleWithLibrariesScope((Module)this.myFacet.getModule()));
            if (manifest != null) {
                PsiField[] fields = manifest.getFields();
                permissionNames = Maps.newHashMapWithExpectedSize((int)fields.length);
                for (PsiField field : fields) {
                    Iterator<String> value;
                    PsiExpression initializer = field.getInitializer();
                    if (!(initializer instanceof PsiLiteralExpression) || !((value = ((PsiLiteralExpression)initializer).getValue()) instanceof String)) continue;
                    permissionNames.put((String)((Object)value), field);
                }
            } else {
                permissionNames = Collections.emptyMap();
            }
            if ((operator = this.myRequirement.getOperator()) == null || operator == JavaTokenType.ANDAND) {
                operator = JavaTokenType.OROR;
            } else if (operator == JavaTokenType.OROR) {
                operator = JavaTokenType.ANDAND;
            }
            PsiElementFactory factory = facade.getElementFactory();
            StringBuilder sb = new StringBuilder(200);
            sb.append("if (");
            boolean first = true;
            PsiClass activityCompat = facade.findClass("android.support.v4.app.ActivityCompat", moduleScope);
            boolean bl = usingAppCompat = activityCompat != null;
            if (usingAppCompat && activityCompat.findMethodsByName("requestPermissions", false).length == 0) {
                usingAppCompat = false;
            }
            for (String permission : this.myRevocablePermissions) {
                PsiField field;
                if (first) {
                    first = false;
                } else {
                    sb.append(' ');
                    if (operator == JavaTokenType.ANDAND) {
                        sb.append("&&");
                    } else if (operator == JavaTokenType.OROR) {
                        sb.append("||");
                    } else if (operator == JavaTokenType.XOR) {
                        sb.append("^");
                    }
                    sb.append(' ');
                }
                if (usingAppCompat) {
                    sb.append("android.support.v4.app.ActivityCompat.");
                }
                sb.append("checkSelfPermission(");
                if (usingAppCompat) {
                    sb.append("this, ");
                }
                if ((field = (PsiField)permissionNames.get(permission)) != null && field.getContainingClass() != null) {
                    sb.append(field.getContainingClass().getQualifiedName()).append('.').append(field.getName());
                } else {
                    sb.append('\"').append(permission).append('\"');
                }
                sb.append(") != android.content.pm.PackageManager.PERMISSION_GRANTED");
            }
            sb.append(") {\n");
            sb.append(" // TODO: Consider calling\n //    Activity").append(usingAppCompat ? "Compat" : "").append("#requestPermissions\n // here to request the missing permissions, and then overriding\n //   public void onRequestPermissionsResult(int requestCode, String[] permissions,\n //                                          int[] grantResults)\n // to handle the case where the user grants the permission. See the documentation\n // for Activity").append(usingAppCompat ? "Compat" : "").append("#requestPermissions for more details.\n");
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)call, PsiMethod.class, (boolean)true);
            if (method != null && !PsiType.VOID.equals((Object)method.getReturnType())) {
                sb.append("return TODO;\n");
            } else {
                sb.append("return;\n");
            }
            sb.append("}\n");
            String code = sb.toString();
            PsiStatement check = factory.createStatementFromText(code, call);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)check);
            parent.addBefore((PsiElement)check, (PsiElement)statement);
            CodeStyleManager.getInstance((Project)project).reformatRange(parent, check.getTextOffset(), statement.getTextOffset() + statement.getTextLength());
        }
    }

    private static class AddPermissionFix
    extends DefaultLintQuickFix {
        private final AndroidFacet myFacet;
        private final String myPermissionName;
        private final int myMaxVersion;

        public AddPermissionFix(@NotNull AndroidFacet facet, @NotNull String permissionName, int maxVersion) {
            super(null);
            this.myFacet = facet;
            this.myPermissionName = permissionName;
            this.myMaxVersion = maxVersion;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            return String.format("Add Permission %1$s", this.myPermissionName.substring(this.myPermissionName.lastIndexOf(46) + 1));
        }

        @Override
        public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
            VirtualFile manifestFile = AndroidRootUtil.getPrimaryManifestFile(this.myFacet);
            if (manifestFile == null || !ReadonlyStatusHandler.ensureFilesWritable((Project)this.myFacet.getModule().getProject(), (VirtualFile[])new VirtualFile[]{manifestFile})) {
                return;
            }
            Manifest manifest = this.myFacet.getManifest();
            if (manifest == null) {
                return;
            }
            XmlTag manifestTag = manifest.getXmlTag();
            if (manifestTag == null) {
                return;
            }
            XmlTag permissionTag = manifestTag.createChildTag("uses-permission", "", null, false);
            if (permissionTag != null) {
                XmlTag before = null;
                for (XmlTag tag : manifestTag.getSubTags()) {
                    String name;
                    String tagName = tag.getName();
                    if (tagName.equals("application")) {
                        before = tag;
                        break;
                    }
                    if (!tagName.equals("uses-permission") && !tagName.equals("uses-permission-sdk-23") && !tagName.equals("uses-permission-sdk-m") || (name = tag.getAttributeValue("name", "http://schemas.android.com/apk/res/android")) == null || name.compareTo(this.myPermissionName) <= 0) continue;
                    before = tag;
                    break;
                }
                permissionTag = before == null ? manifestTag.addSubTag(permissionTag, false) : (XmlTag)manifestTag.addBefore((PsiElement)permissionTag, before);
                permissionTag.setAttribute("name", "http://schemas.android.com/apk/res/android", this.myPermissionName);
                if (this.myMaxVersion != Integer.MAX_VALUE && this.myMaxVersion >= AndroidModuleInfo.getInstance(this.myFacet).getMinSdkVersion().getApiLevel()) {
                    permissionTag.setAttribute("maxSdkVersion", "http://schemas.android.com/apk/res/android", Integer.toString(this.myMaxVersion));
                }
                Project project = this.myFacet.getModule().getProject();
                CodeStyleManager.getInstance((Project)project).reformat((PsiElement)permissionTag);
                FileDocumentManager.getInstance().saveAllDocuments();
                PsiFile containingFile = permissionTag.getContainingFile();
                if (containingFile != null) {
                    DaemonCodeAnalyzer.getInstance((Project)project).restart();
                }
            }
        }
    }
}

