/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.RenameXmlTagQuickFix;
import com.android.tools.lint.checks.NetworkSecurityConfigDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import java.util.List;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.RenameAttributeQuickFix;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLintNetworkSecurityConfigInspection
extends AndroidLintInspectionBase {
    public AndroidLintNetworkSecurityConfigInspection() {
        super(AndroidBundle.message("android.lint.inspections.network.security.config", new Object[0]), NetworkSecurityConfigDetector.ISSUE);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message, @Nullable LintFix fixData) {
        if (NetworkSecurityConfigDetector.isAttributeSpellingError((String)message)) {
            XmlTag parentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false);
            XmlAttribute currentAttr = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlAttribute.class, (boolean)false);
            assert (parentTag != null);
            assert (currentAttr != null);
            List suggestions = NetworkSecurityConfigDetector.getAttributeSpellingSuggestions((String)currentAttr.getName(), (String)parentTag.getName());
            AndroidLintQuickFix[] attrFixes = new AndroidLintQuickFix[suggestions.size()];
            for (int i = 0; i < attrFixes.length; ++i) {
                attrFixes[i] = new RenameAttributeQuickFix(null, (String)suggestions.get(i));
            }
            return attrFixes;
        }
        if (NetworkSecurityConfigDetector.isTagSpellingError((String)message)) {
            XmlTag currentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false);
            assert (currentTag != null);
            XmlTag parentTag = currentTag.getParentTag();
            assert (parentTag != null);
            List suggestions = NetworkSecurityConfigDetector.getTagSpellingSuggestions((String)currentTag.getName(), (String)parentTag.getName());
            AndroidLintQuickFix[] elementQuickFixes = new AndroidLintQuickFix[suggestions.size()];
            for (int i = 0; i < elementQuickFixes.length; ++i) {
                elementQuickFixes[i] = new RenameXmlTagQuickFix((String)suggestions.get(i));
            }
            return elementQuickFixes;
        }
        return super.getQuickFixes(startElement, endElement, message, fixData);
    }
}

