/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.ide.common.res2.DataFile;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.ResourceFolderType;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceFolderRegistry;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.android.tools.lint.checks.ApiDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.intellij.codeInsight.daemon.impl.quickfix.SimplifyBooleanExpressionFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLintObsoleteSdkIntInspection
extends AndroidLintInspectionBase {
    public AndroidLintObsoleteSdkIntInspection() {
        super(AndroidBundle.message("android.lint.inspections.obsolete.sdk.int", new Object[0]), ApiDetector.OBSOLETE_SDK);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message, @Nullable LintFix fixData) {
        if (fixData instanceof LintFix.DataMap) {
            LintFix.DataMap map = (LintFix.DataMap)fixData;
            Boolean constant = (Boolean)map.get(Boolean.class);
            if (constant != null) {
                PsiBinaryExpression subExpression = (PsiBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiBinaryExpression.class, (boolean)false);
                if (subExpression != null) {
                    return new AndroidLintQuickFix[]{new AndroidLintQuickFix.LocalFixWrappee((LocalQuickFixOnPsiElement)new SimplifyBooleanExpressionFix((PsiExpression)subExpression, constant.booleanValue()))};
                }
            } else {
                File file = (File)map.get(File.class);
                AndroidVersion minSdkVersion = (AndroidVersion)map.get(AndroidVersion.class);
                String destFolder = (String)map.get(String.class);
                if (file != null && destFolder != null && minSdkVersion != null) {
                    AndroidFacet facet = AndroidFacet.getInstance(startElement);
                    VirtualFile dir = StandardFileSystems.local().findFileByPath(file.getPath());
                    if (facet != null && dir != null) {
                        return new AndroidLintQuickFix[]{new MergeResourceFolderFix(facet, dir, destFolder, minSdkVersion)};
                    }
                }
            }
        }
        return super.getQuickFixes(startElement, endElement, message, fixData);
    }

    private static class MergeResourceFolderFix
    implements AndroidLintQuickFix {
        private final AndroidFacet facet;
        private final VirtualFile dir;
        private final String destFolderName;
        private final AndroidVersion minSdkVersion;
        List<VirtualFile> sourceFolders;

        public MergeResourceFolderFix(@NotNull AndroidFacet facet, @NotNull VirtualFile dir, @NotNull String destFolderName, AndroidVersion minSdkVersion) {
            this.facet = facet;
            this.dir = dir;
            this.destFolderName = destFolderName;
            this.minSdkVersion = minSdkVersion;
        }

        private List<VirtualFile> findSourceFolders() {
            if (this.sourceFolders == null) {
                ArrayList folders = Lists.newArrayList();
                int apiLevel = this.minSdkVersion.getFeatureLevel();
                String dirName = this.dir.getName();
                FolderConfiguration oldConfig = FolderConfiguration.getConfigForFolder((String)dirName);
                assert (oldConfig != null);
                assert (oldConfig.getVersionQualifier() != null);
                int startingVersion = oldConfig.getVersionQualifier().getVersion();
                oldConfig.setVersionQualifier(null);
                ResourceFolderType folderType = ResourceFolderType.getFolderType((String)dirName);
                for (VirtualFile folder : this.dir.getParent().getChildren()) {
                    VersionQualifier versionQualifier;
                    FolderConfiguration siblingConfig;
                    if (!folder.isDirectory() || folderType != ResourceFolderType.getFolderType((String)folder.getName()) || (siblingConfig = FolderConfiguration.getConfigForFolder((String)folder.getName())) == null || (versionQualifier = siblingConfig.getVersionQualifier()) == null || versionQualifier.hasFakeValue() || versionQualifier.getVersion() > apiLevel || versionQualifier.getVersion() < startingVersion) continue;
                    siblingConfig.setVersionQualifier(null);
                    if (!siblingConfig.equals((Object)oldConfig)) continue;
                    folders.add(folder);
                }
                Collections.sort(folders, (f1, f2) -> {
                    FolderConfiguration configuration1 = FolderConfiguration.getConfigForFolder((String)f1.getName());
                    FolderConfiguration configuration2 = FolderConfiguration.getConfigForFolder((String)f2.getName());
                    assert (configuration1 != null);
                    assert (configuration2 != null);
                    return -configuration1.compareTo(configuration2);
                });
                this.sourceFolders = folders;
            }
            return this.sourceFolders;
        }

        @Override
        public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
            ResourceFolderRepository repository = ResourceFolderRegistry.get(this.facet, this.dir.getParent());
            Project project = this.facet.getModule().getProject();
            List<VirtualFile> folders = this.findSourceFolders();
            if (!folders.isEmpty()) {
                for (int i = 0; i < folders.size() - 1; ++i) {
                    VirtualFile folder = folders.get(i);
                    VirtualFile target = folders.get(i + 1);
                    MergeResourceFolderFix.mergeResourceFolder(project, folder, target.getName(), repository);
                }
                MergeResourceFolderFix.mergeResourceFolder(project, folders.get(folders.size() - 1), this.destFolderName, repository);
            }
        }

        private static void mergeResourceFolder(@NotNull Project project, @NotNull VirtualFile dir, @NotNull String targetDir, @NotNull LocalResourceRepository repository) {
            Class<AndroidLintInspectionBase> requestor = AndroidLintInspectionBase.class;
            VirtualFileSystem fileSystem = StandardFileSystems.local();
            FolderConfiguration oldConfig = FolderConfiguration.getConfigForFolder((String)dir.getName());
            FolderConfiguration newConfig = FolderConfiguration.getConfigForFolder((String)targetDir);
            assert (oldConfig != null);
            assert (newConfig != null);
            ArrayListMultimap destFolderResources = ArrayListMultimap.create((int)100, (int)2);
            ArrayList srcItems = Lists.newArrayList();
            for (ListMultimap multimap : repository.getItems().values()) {
                for (ResourceItem item : multimap.values()) {
                    if (item.getSourceType() == DataFile.FileType.GENERATED_FILES) continue;
                    FolderConfiguration configuration = item.getConfiguration();
                    if (oldConfig.equals((Object)configuration)) {
                        VirtualFile sourceFile;
                        ResourceFile source = (ResourceFile)item.getSource();
                        if (source == null || (sourceFile = fileSystem.findFileByPath(source.getFile().getPath())) == null || !dir.equals(sourceFile.getParent())) continue;
                        srcItems.add(item);
                        continue;
                    }
                    if (!newConfig.equals((Object)configuration)) continue;
                    destFolderResources.put((Object)item.getName(), (Object)item.getType());
                }
            }
            VirtualFile res = dir.getParent();
            if (res == null) {
                return;
            }
            try {
                VirtualFile destDir = res.findOrCreateChildData(requestor, targetDir);
                for (ResourceItem item : srcItems) {
                    DataFile.FileType sourceType = item.getSourceType();
                    if (sourceType == DataFile.FileType.GENERATED_FILES) continue;
                    boolean isInDest = destFolderResources.containsEntry((Object)item.getName(), (Object)item.getType());
                    if (((ResourceFile)item.getSource()).getFile().getParentFile().getName().startsWith("values")) {
                        String value = StringUtil.notNullize((String)item.getValueText());
                        ResourceFile source = (ResourceFile)item.getSource();
                        String fileName = source != null ? source.getFile().getName() : "values.xml";
                        List<String> dirNames = Collections.singletonList(targetDir);
                        if (isInDest) {
                            AndroidResourceUtil.changeValueResource(project, res, item.getName(), item.getType(), value, fileName, dirNames, false);
                            continue;
                        }
                        AndroidResourceUtil.createValueResource(project, res, item.getName(), item.getType(), fileName, dirNames, value);
                        continue;
                    }
                    VirtualFile source = fileSystem.findFileByPath(item.getFile().getPath());
                    if (source != null) {
                        VirtualFile existing = destDir.findChild(source.getName());
                        if (existing != null) {
                            existing.delete(requestor);
                        }
                        VfsUtilCore.copyFile(requestor, (VirtualFile)source, (VirtualFile)destDir);
                        continue;
                    }
                    return;
                }
                for (VirtualFile resourceFile : dir.getChildren()) {
                    resourceFile.delete(requestor);
                }
                dir.delete(requestor);
            }
            catch (IOException e) {
                Logger.getInstance(AndroidLintInspectionBase.class).error((Throwable)e);
            }
        }

        @Override
        public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
            return this.dir.isDirectory();
        }

        @Override
        @NotNull
        public String getName() {
            List<VirtualFile> folders = this.findSourceFolders();
            ArrayList names = Lists.newArrayListWithCapacity((int)folders.size());
            for (VirtualFile file : folders) {
                String name = file.getName();
                int index = name.indexOf(45);
                if (index != -1) {
                    name = name.substring(index);
                }
                names.add(name);
            }
            String sourceFolders = Joiner.on((String)" and ").join((Iterable)names);
            return String.format("Merge resources from %1$s into %2$s", sourceFolders, this.destFolderName);
        }
    }
}

