/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.lint.checks.AnnotationDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.TextFormat;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.List;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLintSwitchIntDefInspection
extends AndroidLintInspectionBase {
    public AndroidLintSwitchIntDefInspection() {
        super(AndroidBundle.message("android.lint.inspections.switch.int.def", new Object[0]), AnnotationDetector.SWITCH_TYPE_DEF);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message, @Nullable LintFix fixData) {
        final List missingCases = (List)LintFix.getData((LintFix)fixData, List.class);
        if (missingCases != null && !missingCases.isEmpty()) {
            return new AndroidLintQuickFix[]{new AndroidLintQuickFix(){

                @Override
                public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
                    if (startElement.getParent() instanceof PsiSwitchStatement) {
                        PsiSwitchStatement switchStatement = (PsiSwitchStatement)startElement.getParent();
                        Project project = switchStatement.getProject();
                        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
                        PsiCodeBlock body = switchStatement.getBody();
                        if (body == null) {
                            return;
                        }
                        PsiElement anchor = body.getLastChild();
                        for (String constant : missingCases) {
                            constant = TextFormat.RAW.convertTo(constant, TextFormat.TEXT);
                            PsiElement parent = anchor.getParent();
                            PsiStatement caseStatement = factory.createStatementFromText("case " + constant + ":", anchor);
                            parent.addBefore((PsiElement)caseStatement, anchor);
                            PsiStatement breakStatement = factory.createStatementFromText("break;", anchor);
                            parent.addBefore((PsiElement)breakStatement, anchor);
                        }
                        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)switchStatement);
                    }
                }

                @Override
                public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
                    return startElement.isValid();
                }

                @Override
                @NotNull
                public String getName() {
                    return "Add Missing @IntDef Constants";
                }
            }};
        }
        return super.getQuickFixes(startElement, endElement, message, fixData);
    }
}

