/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.DefaultLintQuickFix;
import com.android.tools.idea.rendering.webp.ConvertFromWebpAction;
import com.android.tools.lint.checks.IconDetector;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class AndroidLintWebpUnsupportedInspection
extends AndroidLintInspectionBase {
    public AndroidLintWebpUnsupportedInspection() {
        super(AndroidBundle.message("android.lint.inspections.webp.unsupported", new Object[0]), IconDetector.WEBP_UNSUPPORTED);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
        return new AndroidLintQuickFix[]{new ConvertWebpToPngFix()};
    }

    static class ConvertWebpToPngFix
    extends DefaultLintQuickFix {
        public ConvertWebpToPngFix() {
            super("Convert image to PNG");
        }

        @Override
        public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
            VirtualFile file = startElement.getContainingFile().getVirtualFile();
            if (file.exists()) {
                new ConvertFromWebpAction().perform(startElement.getProject(), new VirtualFile[]{file}, true);
            }
        }
    }
}

