/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.ReplaceStringQuickFix;
import com.android.tools.lint.checks.WrongCaseDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLintWrongCaseInspection
extends AndroidLintInspectionBase {
    public AndroidLintWrongCaseInspection() {
        super(AndroidBundle.message("android.lint.inspections.wrong.case", new Object[0]), WrongCaseDetector.WRONG_CASE);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message, @Nullable LintFix fixData) {
        List oldAndNew = (List)LintFix.getData((LintFix)fixData, List.class);
        if (oldAndNew != null && oldAndNew.size() == 2) {
            final String current = (String)oldAndNew.get(0);
            final String proposed = (String)oldAndNew.get(1);
            return new AndroidLintQuickFix[]{new ReplaceStringQuickFix(null, current, proposed){

                @Override
                protected void editAfter(@NotNull Document document) {
                    String text = document.getText();
                    int index = text.indexOf("</" + current + ">");
                    if (index != -1) {
                        document.replaceString(index + 2, index + 2 + current.length(), (CharSequence)proposed);
                    }
                }
            }};
        }
        return super.getQuickFixes(startElement, endElement, message, fixData);
    }
}

