/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.ide.common.blame.SourcePosition;
import com.android.utils.PositionXmlParser;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

class DomPsiConverter {
    private static final DomNodeList EMPTY = new DomNodeList(){

        @Override
        @NotNull
        public DomNode item(int i) {
            throw new IllegalArgumentException();
        }

        @Override
        public int getLength() {
            return 0;
        }

        @Override
        void add(@NotNull DomNode node) {
        }
    };
    @Nullable
    private static final NamedNodeMap EMPTY_ATTRIBUTES = new NamedNodeMap(){

        @Override
        public int getLength() {
            return 0;
        }

        @Override
        @Nullable
        public Node getNamedItem(String s) {
            return null;
        }

        @Override
        @Nullable
        public Node getNamedItemNS(String s, String s2) throws DOMException {
            return null;
        }

        @Override
        @NotNull
        public Node setNamedItem(Node node) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Node removeNamedItem(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Node item(int i) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public Node setNamedItemNS(Node node) throws DOMException {
            return null;
        }

        @Override
        @NotNull
        public Node removeNamedItemNS(String s, String s2) throws DOMException {
            throw new UnsupportedOperationException();
        }
    };

    private DomPsiConverter() {
    }

    @Nullable
    public static Document convert(@NotNull XmlFile xmlFile) {
        try {
            XmlDocument xmlDocument = xmlFile.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            return DomPsiConverter.convert(xmlDocument);
        }
        catch (ProcessCanceledException e) {
            return null;
        }
        catch (Exception e) {
            String path = xmlFile.getName();
            VirtualFile virtualFile = xmlFile.getVirtualFile();
            if (virtualFile != null) {
                path = virtualFile.getPath();
            }
            throw new RuntimeException("Could not convert file " + path, e);
        }
    }

    @Nullable
    private static Document convert(@NotNull XmlDocument document) {
        return new DomDocument(document);
    }

    @Nullable
    public static DomNode findNodeAt(Document document, int offset) {
        assert (document instanceof DomDocument);
        return DomPsiConverter.findElementAt((DomDocument)document, offset);
    }

    @Nullable
    public static DomNode findElementAt(DomNode element, int offset) {
        TextRange range = element.getTextRange();
        if (range == null) {
            return null;
        }
        if (!range.containsOffset(offset)) {
            return null;
        }
        DomNode child = element.getLastChild();
        if (child == null) {
            return null;
        }
        while (child != null) {
            DomNode match = DomPsiConverter.findElementAt(child, offset);
            if (match != null) {
                return match;
            }
            child = child.getPreviousSibling();
        }
        return element;
    }

    @NotNull
    public static TextRange getTextRange(@NotNull Node node) {
        if (!(node instanceof DomNode)) {
            SourcePosition position = PositionXmlParser.getPosition((Node)node);
            return position != SourcePosition.UNKNOWN ? new TextRange(position.getStartOffset(), position.getEndOffset()) : new TextRange(0, 0);
        }
        if (node.getNodeType() == 1) {
            return DomPsiConverter.getTextNameRange(node);
        }
        DomNode domNode = (DomNode)node;
        return domNode.getTextRange();
    }

    @NotNull
    public static TextRange getTextNameRange(@NotNull Node node) {
        XmlElement nameElement;
        if (!(node instanceof DomNode)) {
            return DomPsiConverter.getTextRange(node);
        }
        DomNode domNode = (DomNode)node;
        XmlElement element = domNode.myElement;
        if (node.getNodeType() == 1 && element instanceof XmlTag) {
            String tag = node.getNodeName();
            int index = element.getText().indexOf(tag);
            if (index != -1) {
                TextRange textRange = element.getTextRange();
                int start = textRange.getStartOffset() + index;
                return new TextRange(start, start + tag.length());
            }
        } else if (node.getNodeType() == 2 && element instanceof XmlAttribute && (nameElement = ((XmlAttribute)element).getNameElement()) != null) {
            return nameElement.getTextRange();
        }
        return element.getTextRange();
    }

    @NotNull
    public static TextRange getTextValueRange(@NotNull Node node) {
        XmlAttributeValue valueElement;
        if (!(node instanceof DomNode)) {
            return DomPsiConverter.getTextRange(node);
        }
        DomNode domNode = (DomNode)node;
        XmlElement element = domNode.myElement;
        TextRange textRange = element.getTextRange();
        if (node.getNodeType() == 2 && element instanceof XmlAttribute && (valueElement = ((XmlAttribute)element).getValueElement()) != null) {
            return valueElement.getValueTextRange();
        }
        return textRange;
    }

    @NotNull
    public static XmlElement getPsiElement(@NotNull Node node) {
        DomNode domNode = (DomNode)node;
        return domNode.myElement;
    }

    private static class DomAttr
    extends DomNode
    implements Attr {
        @NotNull
        private final DomElement myOwner;
        @NotNull
        private final XmlAttribute myAttribute;

        private DomAttr(@NotNull Document document, @NotNull DomElement owner, @NotNull XmlAttribute attribute) {
            super(document, null, (XmlElement)attribute);
            this.myOwner = owner;
            this.myAttribute = attribute;
        }

        @Override
        @NotNull
        public String getNodeName() {
            return this.getName();
        }

        @Override
        @NotNull
        public String getNodeValue() throws DOMException {
            return this.getValue();
        }

        @Override
        public short getNodeType() {
            return 2;
        }

        @Override
        @NotNull
        public String getName() {
            Application application = ApplicationManager.getApplication();
            if (!application.isReadAccessAllowed()) {
                return (String)application.runReadAction(this::getName);
            }
            return this.myAttribute.getName();
        }

        @Override
        public boolean getSpecified() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String getValue() {
            Application application = ApplicationManager.getApplication();
            if (!application.isReadAccessAllowed()) {
                return (String)application.runReadAction(this::getValue);
            }
            String value = this.myAttribute.getValue();
            if (value == null) {
                value = "";
            }
            return value;
        }

        @Override
        @NotNull
        public String getLocalName() {
            Application application = ApplicationManager.getApplication();
            if (!application.isReadAccessAllowed()) {
                return (String)application.runReadAction(this::getLocalName);
            }
            return this.myAttribute.getLocalName();
        }

        @Override
        @NotNull
        public String getPrefix() {
            Application application = ApplicationManager.getApplication();
            if (!application.isReadAccessAllowed()) {
                return (String)application.runReadAction(this::getPrefix);
            }
            return this.myAttribute.getNamespacePrefix();
        }

        @Override
        @NotNull
        public String getNamespaceURI() {
            Application application = ApplicationManager.getApplication();
            if (!application.isReadAccessAllowed()) {
                return (String)application.runReadAction(this::getNamespaceURI);
            }
            return this.myAttribute.getNamespace();
        }

        @Override
        public void setValue(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Element getOwnerElement() {
            return this.myOwner;
        }

        @Override
        @NotNull
        public TypeInfo getSchemaTypeInfo() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isId() {
            throw new UnsupportedOperationException();
        }
    }

    private static class DomComment
    extends DomNode
    implements Comment {
        @NotNull
        private final XmlComment myComment;

        private DomComment(@NotNull Document owner, @NotNull DomNode parent, @NotNull XmlComment comment) {
            super(owner, parent, (XmlElement)comment);
            this.myComment = comment;
        }

        @Override
        @Nullable
        public String getNodeName() {
            return null;
        }

        @Override
        @NotNull
        public String getNodeValue() throws DOMException {
            Application application = ApplicationManager.getApplication();
            if (!application.isReadAccessAllowed()) {
                return (String)application.runReadAction(this::getNodeValue);
            }
            return this.myComment.getText();
        }

        @Override
        public short getNodeType() {
            return 8;
        }

        @Override
        @NotNull
        public String getTextContent() throws DOMException {
            return this.getNodeValue();
        }
    }

    private static class DomText
    extends DomNode
    implements Text {
        @NotNull
        private final XmlText myText;

        private DomText(@NotNull Document owner, @NotNull DomNode parent, @NotNull XmlText text) {
            super(owner, parent, (XmlElement)text);
            this.myText = text;
        }

        @Override
        @Nullable
        public String getNodeName() {
            return null;
        }

        @Override
        @NotNull
        public String getNodeValue() throws DOMException {
            Application application = ApplicationManager.getApplication();
            if (!application.isReadAccessAllowed()) {
                return (String)application.runReadAction(this::getNodeValue);
            }
            return this.myText.getText();
        }

        @Override
        public short getNodeType() {
            return 3;
        }

        @Override
        @NotNull
        public Text splitText(int i) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isElementContentWhitespace() {
            String s = this.myText.getText();
            int n = s.length();
            for (int i = 0; i < n; ++i) {
                if (Character.isWhitespace(s.charAt(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        @NotNull
        public String getWholeText() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Text replaceWholeText(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }
    }

    private static class DomElement
    extends DomNode
    implements Element {
        private final XmlTag myTag;
        @Nullable
        private NamedNodeMap myAttributes;

        private DomElement(@NotNull Document owner, @NotNull DomNode parent, @NotNull XmlTag tag) {
            super(owner, parent, (XmlElement)tag);
            this.myTag = tag;
        }

        @Override
        @NotNull
        public String getNodeName() {
            return this.getTagName();
        }

        @Override
        @Nullable
        public String getNodeValue() throws DOMException {
            return null;
        }

        @Override
        public short getNodeType() {
            return 1;
        }

        @Override
        @NotNull
        public String getNamespaceURI() {
            Application application = ApplicationManager.getApplication();
            if (!application.isReadAccessAllowed()) {
                return (String)application.runReadAction(() -> ((XmlTag)this.myTag).getNamespace());
            }
            return this.myTag.getNamespace();
        }

        @Override
        @NotNull
        public NamedNodeMap getAttributes() {
            Application application = ApplicationManager.getApplication();
            if (!application.isReadAccessAllowed()) {
                return (NamedNodeMap)application.runReadAction(this::getAttributes);
            }
            if (this.myAttributes == null) {
                XmlAttribute[] attributes = this.myTag.getAttributes();
                this.myAttributes = attributes.length == 0 ? EMPTY_ATTRIBUTES : new DomNamedNodeMap(this, attributes);
            }
            return this.myAttributes;
        }

        @Override
        @NotNull
        public String getTagName() {
            Application application = ApplicationManager.getApplication();
            if (!application.isReadAccessAllowed()) {
                return (String)application.runReadAction(this::getTagName);
            }
            return this.myTag.getName();
        }

        @Override
        @Nullable
        public String getLocalName() {
            Application application = ApplicationManager.getApplication();
            if (!application.isReadAccessAllowed()) {
                return (String)application.runReadAction(this::getTagName);
            }
            return this.myTag.getLocalName();
        }

        @Override
        @NotNull
        public String getAttribute(@NotNull String name) {
            Node node = this.getAttributes().getNamedItem(name);
            if (node != null) {
                return node.getNodeValue();
            }
            return "";
        }

        @Override
        @NotNull
        public String getAttributeNS(@NotNull String namespace, @NotNull String name) throws DOMException {
            Node node = this.getAttributes().getNamedItemNS(namespace, name);
            if (node != null) {
                return node.getNodeValue();
            }
            return "";
        }

        @Override
        @Nullable
        public Attr getAttributeNodeNS(@NotNull String namespace, @NotNull String name) throws DOMException {
            Node node = this.getAttributes().getNamedItemNS(namespace, name);
            if (node != null) {
                return (Attr)node;
            }
            return null;
        }

        @Override
        @Nullable
        public Attr getAttributeNode(@NotNull String name) {
            Node node = this.getAttributes().getNamedItem(name);
            if (node != null) {
                return (Attr)node;
            }
            return null;
        }

        @Override
        public boolean hasAttribute(@NotNull String name) {
            return this.getAttributes().getNamedItem(name) != null;
        }

        @Override
        public boolean hasAttributeNS(@NotNull String namespace, @NotNull String name) throws DOMException {
            return this.getAttributes().getNamedItemNS(namespace, name) != null;
        }

        @Override
        @NotNull
        public NodeList getElementsByTagName(@NotNull String s) {
            DomNodeList childNodes = this.getChildNodes();
            if (childNodes == EMPTY) {
                return EMPTY;
            }
            DomNodeList matches = new DomNodeList();
            int n = childNodes.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = childNodes.item(i);
                if (!s.equals(node.getNodeName())) continue;
                matches.add((DomNode)node);
            }
            return matches;
        }

        @Override
        @NotNull
        public NodeList getElementsByTagNameNS(String s, String s2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Attr setAttributeNode(Attr attr) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Attr removeAttributeNode(Attr attr) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAttributeNS(String s, String s2, String s3) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeAttributeNS(String s, String s2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAttribute(String s, String s2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeAttribute(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Attr setAttributeNodeNS(Attr attr) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public TypeInfo getSchemaTypeInfo() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setIdAttribute(String s, boolean b) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setIdAttributeNS(String s, String s2, boolean b) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setIdAttributeNode(Attr attr, boolean b) throws DOMException {
            throw new UnsupportedOperationException();
        }
    }

    private static class DomDocument
    extends DomNode
    implements Document {
        @NotNull
        private final XmlDocument myPsiDocument;
        @Nullable
        private DomElement myRoot;

        private DomDocument(@NotNull XmlDocument document) {
            super(null, null, (XmlElement)document);
            this.myPsiDocument = document;
        }

        @Override
        @Nullable
        public String getNodeName() {
            return null;
        }

        @Override
        @Nullable
        public String getNodeValue() throws DOMException {
            return null;
        }

        @Override
        public short getNodeType() {
            return 9;
        }

        @Override
        @NotNull
        public DomNodeList getChildNodes() {
            if (this.myChildren == null) {
                DomNodeList list;
                this.myChildren = list = new DomNodeList();
                DomNode documentElement = (DomNode)((Object)this.getDocumentElement());
                if (documentElement != null) {
                    list.add(documentElement);
                }
            }
            return this.myChildren;
        }

        @Override
        @NotNull
        public DocumentType getDoctype() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public DOMImplementation getImplementation() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public Element getDocumentElement() {
            if (this.myRoot == null) {
                XmlTag rootTag = this.myPsiDocument.getRootTag();
                if (rootTag == null) {
                    return null;
                }
                this.myRoot = new DomElement(this, this, rootTag);
            }
            return this.myRoot;
        }

        @Override
        @NotNull
        public NodeList getElementsByTagName(String s) {
            Element root = this.getDocumentElement();
            if (root != null) {
                return root.getElementsByTagName(s);
            }
            return EMPTY;
        }

        @Override
        @NotNull
        public NodeList getElementsByTagNameNS(String s, String s2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Element createElement(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public DocumentFragment createDocumentFragment() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Text createTextNode(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Comment createComment(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public CDATASection createCDATASection(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public ProcessingInstruction createProcessingInstruction(String s, String s2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Attr createAttribute(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public EntityReference createEntityReference(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Node importNode(Node node, boolean b) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Element createElementNS(String s, String s2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Attr createAttributeNS(String s, String s2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Element getElementById(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String getInputEncoding() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String getXmlEncoding() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getXmlStandalone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setXmlStandalone(boolean b) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String getXmlVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setXmlVersion(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getStrictErrorChecking() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setStrictErrorChecking(boolean b) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String getDocumentURI() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setDocumentURI(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Node adoptNode(Node node) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public DOMConfiguration getDomConfig() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void normalizeDocument() {
        }

        @Override
        @NotNull
        public Node renameNode(Node node, String s, String s2) throws DOMException {
            throw new UnsupportedOperationException();
        }
    }

    private static abstract class DomNode
    implements Node {
        @Nullable
        protected final Document myOwner;
        @Nullable
        protected final DomNode myParent;
        @NotNull
        protected final XmlElement myElement;
        @Nullable
        protected DomNodeList myChildren;
        @Nullable
        protected DomNode myNext;
        @Nullable
        protected DomNode myPrevious;

        protected DomNode(@Nullable Document owner, @Nullable DomNode parent, @NotNull XmlElement element) {
            this.myOwner = owner;
            this.myParent = parent;
            this.myElement = element;
        }

        @Override
        @Nullable
        public Node getParentNode() {
            return this.myParent;
        }

        @Override
        @NotNull
        public DomNodeList getChildNodes() {
            if (this.myChildren == null) {
                PsiElement[] children = this.myElement.getChildren();
                if (children.length > 0) {
                    DomNodeList list;
                    this.myChildren = list = new DomNodeList();
                    assert (this.myOwner != null);
                    for (PsiElement child : children) {
                        if (child instanceof XmlTag) {
                            list.add(new DomElement(this.myOwner, this, (XmlTag)child));
                            continue;
                        }
                        if (child instanceof XmlText) {
                            list.add(new DomText(this.myOwner, this, (XmlText)child));
                            continue;
                        }
                        if (!(child instanceof XmlComment)) continue;
                        list.add(new DomComment(this.myOwner, this, (XmlComment)child));
                    }
                } else {
                    this.myChildren = EMPTY;
                }
            }
            return this.myChildren;
        }

        @Override
        @Nullable
        public DomNode getFirstChild() {
            DomNodeList childNodes = this.getChildNodes();
            if (childNodes.getLength() > 0) {
                return childNodes.item(0);
            }
            return null;
        }

        @Override
        @Nullable
        public DomNode getLastChild() {
            DomNodeList childNodes = this.getChildNodes();
            if (childNodes.getLength() > 0) {
                return childNodes.item(0);
            }
            return null;
        }

        @Override
        @Nullable
        public DomNode getPreviousSibling() {
            return this.myPrevious;
        }

        @Override
        @Nullable
        public DomNode getNextSibling() {
            return this.myNext;
        }

        @Override
        @Nullable
        public NamedNodeMap getAttributes() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public Document getOwnerDocument() {
            return this.myOwner;
        }

        @Override
        public void setNodeValue(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Node insertBefore(Node node, Node node2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Node replaceChild(Node node, Node node2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Node removeChild(Node node) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Node appendChild(Node node) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasChildNodes() {
            return this.getChildNodes().getLength() > 0;
        }

        @Override
        @NotNull
        public Node cloneNode(boolean b) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void normalize() {
        }

        @Override
        public boolean isSupported(String s, String s2) {
            return false;
        }

        @Override
        @NotNull
        public String getNamespaceURI() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String getPrefix() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPrefix(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public String getLocalName() {
            return null;
        }

        @Override
        public boolean hasAttributes() {
            return false;
        }

        @Override
        @Nullable
        public String getBaseURI() {
            return null;
        }

        @Override
        public short compareDocumentPosition(Node node) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTextContent() throws DOMException {
            return this.myElement.getText();
        }

        @Override
        public void setTextContent(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isSameNode(Node node) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String lookupPrefix(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isDefaultNamespace(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String lookupNamespaceURI(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEqualNode(Node node) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Object getFeature(String s, String s2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Object setUserData(String s, Object o, UserDataHandler userDataHandler) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Object getUserData(String s) {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public String getData() throws DOMException {
            throw new UnsupportedOperationException();
        }

        public void setData(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public int getLength() {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public String substringData(int i, int i2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public void appendData(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public void insertData(int i, String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public void deleteData(int i, int i2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public void replaceData(int i, int i2, String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public TextRange getTextRange() {
            return this.myElement.getTextRange();
        }
    }

    private static class DomNamedNodeMap
    implements NamedNodeMap {
        @NotNull
        protected final Map<String, DomNode> myMap;
        @NotNull
        protected final Map<String, Map<String, DomNode>> myNsMap;
        @NotNull
        protected final List<DomNode> mItems;

        private DomNamedNodeMap(@NotNull DomElement element, @NotNull XmlAttribute[] attributes) {
            int count = attributes.length;
            int namespaceCount = 0;
            for (XmlAttribute attribute : attributes) {
                if (attribute.getNamespace().isEmpty()) continue;
                ++namespaceCount;
            }
            this.myMap = new HashMap(count - namespaceCount);
            this.myNsMap = new HashMap(namespaceCount);
            this.mItems = new ArrayList<DomNode>(count);
            assert (element.myOwner != null);
            for (XmlAttribute attribute : attributes) {
                DomAttr attr = new DomAttr(element.myOwner, element, attribute);
                this.mItems.add(attr);
                String namespace = attribute.getNamespace();
                if (!namespace.isEmpty()) {
                    HashMap map = this.myNsMap.get(namespace);
                    if (map == null) {
                        map = new HashMap();
                        this.myNsMap.put(namespace, (Map<String, DomNode>)map);
                    }
                    map.put(attribute.getLocalName(), attr);
                    continue;
                }
                this.myMap.put(attribute.getName(), attr);
            }
        }

        @Override
        public Node item(int i) {
            return this.mItems.get(i);
        }

        @Override
        public int getLength() {
            return this.mItems.size();
        }

        @Override
        public Node getNamedItem(@NotNull String s) {
            return this.myMap.get(s);
        }

        @Override
        @Nullable
        public Node getNamedItemNS(@NotNull String namespace, @NotNull String name) throws DOMException {
            Map<String, DomNode> map = this.myNsMap.get(namespace);
            if (map != null) {
                return map.get(name);
            }
            return null;
        }

        @Override
        @NotNull
        public Node setNamedItem(Node node) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Node removeNamedItem(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Node setNamedItemNS(Node node) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Node removeNamedItemNS(String s, String s2) throws DOMException {
            throw new UnsupportedOperationException();
        }
    }

    private static class DomNodeList
    implements NodeList {
        protected final List<DomNode> myChildren = new ArrayList<DomNode>();

        private DomNodeList() {
        }

        @Override
        @NotNull
        public DomNode item(int i) {
            return this.myChildren.get(i);
        }

        @Override
        public int getLength() {
            return this.myChildren.size();
        }

        void add(@NotNull DomNode node) {
            int size = this.myChildren.size();
            if (size > 0) {
                DomNode last;
                node.myPrevious = last = this.myChildren.get(size - 1);
                last.myNext = node;
            }
            this.myChildren.add(node);
        }
    }
}

