/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.lint.detector.api.LintFix;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DocumentUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.RegEx;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceStringQuickFix
implements AndroidLintQuickFix {
    private final String myName;
    @RegEx
    private final String myRegexp;
    private final String myNewValue;
    private boolean myShortenNames;
    private boolean myFormat;
    private SmartPsiFileRange myRange;
    private String myExpandedNewValue;

    public ReplaceStringQuickFix(@Nullable String name, @RegEx @Nullable String regexp, @NotNull String newValue) {
        this.myName = name;
        this.myNewValue = newValue;
        if (regexp != null && regexp.indexOf(40) == -1) {
            regexp = "(" + Pattern.quote(regexp) + ")";
        }
        this.myRegexp = regexp;
    }

    public ReplaceStringQuickFix setShortenNames(boolean shortenNames) {
        this.myShortenNames = shortenNames;
        return this;
    }

    public ReplaceStringQuickFix setFormat(boolean format) {
        this.myFormat = format;
        return this;
    }

    public void setRange(SmartPsiFileRange range) {
        this.myRange = range;
    }

    @Override
    @NotNull
    public String getName() {
        if (this.myName == null) {
            return "Replace with " + this.myNewValue;
        }
        return this.myName;
    }

    @Nullable
    protected String getNewValue() {
        return this.myExpandedNewValue != null ? this.myExpandedNewValue : this.myNewValue;
    }

    protected void editBefore(@NotNull Document document) {
    }

    protected void editAfter(@NotNull Document document) {
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        PsiFile file = startElement.getContainingFile();
        Document document = FileDocumentManager.getInstance().getDocument(file.getVirtualFile());
        if (document != null) {
            this.editBefore(document);
            TextRange range = this.getRange(startElement, endElement, true);
            if (range != null) {
                String newValue = this.getNewValue();
                if (newValue == null) {
                    newValue = "";
                }
                if (ReplaceStringQuickFix.whitespaceOnly(newValue)) {
                    range = ReplaceStringQuickFix.includeFullLineIfOnlySpace(document, range);
                }
                int startOffset = range.getStartOffset();
                int endOffset = range.getEndOffset();
                document.replaceString(startOffset, endOffset, (CharSequence)newValue);
                endOffset = startOffset + newValue.length();
                this.editAfter(document);
                if (this.myShortenNames || this.myFormat) {
                    Project project = startElement.getProject();
                    PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
                    documentManager.commitDocument(document);
                    PsiElement element = file.findElementAt(startOffset);
                    if (element == null) {
                        return;
                    }
                    if (this.myShortenNames && element.getLanguage() == JavaLanguage.INSTANCE) {
                        PsiElement parent;
                        PsiElement end = file.findElementAt(endOffset);
                        PsiElement psiElement = parent = end != null ? PsiTreeUtil.findCommonParent((PsiElement)element.getParent(), (PsiElement)end) : element.getParent();
                        if (parent == null) {
                            parent = element.getParent();
                        }
                        parent = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(parent);
                        if (this.myFormat) {
                            CodeStyleManager.getInstance((Project)project).reformat(parent);
                        }
                    } else if (this.myFormat) {
                        CodeStyleManager.getInstance((Project)project).reformatRange(element, startOffset, endOffset);
                    }
                }
            }
        }
    }

    private static boolean whitespaceOnly(@NotNull String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isWhitespace(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static TextRange includeFullLineIfOnlySpace(@NotNull Document document, @NotNull TextRange range) {
        int startOffset = range.getStartOffset();
        int endOffset = range.getEndOffset();
        int lineStart = DocumentUtil.getLineStartOffset((int)startOffset, (Document)document);
        int lineEnd = DocumentUtil.getLineEndOffset((int)startOffset, (Document)document);
        String prefix = document.getText(new TextRange(lineStart, startOffset));
        String suffix = document.getText(new TextRange(endOffset, lineEnd));
        if (ReplaceStringQuickFix.whitespaceOnly(prefix) && ReplaceStringQuickFix.whitespaceOnly(suffix)) {
            return new TextRange(lineStart, lineEnd + 1);
        }
        return range;
    }

    @Nullable
    private TextRange getRange(PsiElement startElement, PsiElement endElement, boolean computeReplacement) {
        int end;
        int start;
        block15: {
            Segment segment;
            if (!startElement.isValid() || !endElement.isValid()) {
                return null;
            }
            start = startElement.getTextOffset();
            end = endElement.getTextOffset() + endElement.getTextLength();
            if (this.myRange != null && (segment = this.myRange.getRange()) != null) {
                start = segment.getStartOffset();
                end = segment.getEndOffset();
            }
            if (this.myRegexp != null) {
                try {
                    String sequence;
                    Pattern pattern = Pattern.compile(this.myRegexp, 8);
                    PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)startElement, (PsiElement)endElement);
                    if (parent != null && parent.getTextRange().containsRange(start, end)) {
                        TextRange parentRange = parent.getTextRange();
                        int offset = parentRange.getStartOffset();
                        sequence = parent.getText().substring(start - offset, end - offset);
                    } else {
                        String text = startElement.getContainingFile().getText();
                        sequence = text.substring(start, end);
                    }
                    Matcher matcher = pattern.matcher(sequence);
                    if (matcher.find()) {
                        end = start;
                        if (matcher.groupCount() > 0) {
                            if (this.myRegexp.contains("target")) {
                                try {
                                    start += matcher.start("target");
                                    end += matcher.end("target");
                                }
                                catch (IllegalArgumentException ignore) {
                                    start += matcher.start(1);
                                    end += matcher.end(1);
                                }
                            } else {
                                start += matcher.start(1);
                                end += matcher.end(1);
                            }
                        } else {
                            start += matcher.start();
                            end += matcher.end();
                        }
                        if (computeReplacement && this.myExpandedNewValue == null) {
                            this.myExpandedNewValue = LintFix.ReplaceString.expandBackReferences((String)this.myNewValue, (Matcher)matcher);
                        }
                        break block15;
                    }
                    return null;
                }
                catch (Exception e) {
                    Logger.getInstance(ReplaceStringQuickFix.class).warn("Invalid regular expression " + this.myRegexp);
                    return null;
                }
            }
        }
        return new TextRange(start, end);
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        return this.getRange(startElement, endElement, false) != null;
    }
}

