/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.lint.DefaultLintQuickFix;
import com.android.tools.idea.lint.GenerateBackupDescriptorFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.inspections.lint.SetAttributeQuickFix;
import org.jetbrains.annotations.NotNull;

class SetAndGenerateBackupDescriptor
extends DefaultLintQuickFix {
    private static final String RESOURCE_URL_NAME = "backup_descriptor";
    private final SetAttributeQuickFix mySetAttributeQuickFix;
    private final GenerateBackupDescriptorFix myGenerateDescriptorFix;

    public SetAndGenerateBackupDescriptor() {
        super("Set fullBackupContent attribute and generate descriptor");
        ResourceUrl resourceUrl = ResourceUrl.create((ResourceType)ResourceType.XML, (String)RESOURCE_URL_NAME, (boolean)false);
        this.mySetAttributeQuickFix = new SetAttributeQuickFix(this.myName, "fullBackupContent", resourceUrl.toString());
        this.myGenerateDescriptorFix = new GenerateBackupDescriptorFix(resourceUrl);
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        this.mySetAttributeQuickFix.apply(startElement, endElement, context);
        this.myGenerateDescriptorFix.apply(startElement, endElement, context);
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        return SetAndGenerateBackupDescriptor.isAllowBackupEnabled(startElement) && this.mySetAttributeQuickFix.isApplicable(startElement, endElement, contextType) && this.myGenerateDescriptorFix.isApplicable(startElement, endElement, contextType);
    }

    static boolean isAllowBackupEnabled(@NotNull PsiElement startElement) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false);
        if (tag == null) {
            return true;
        }
        return !"false".equals(tag.getAttributeValue("allowBackup", "http://schemas.android.com/apk/res/android"));
    }
}

