/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.logcat.LogCatHeader;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.ddmlib.logcat.LogCatTimestamp;
import com.android.tools.idea.logcat.AndroidLogcatReceiver;
import com.android.tools.idea.run.LoggingReceiver;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.intellij.execution.impl.ConsoleBuffer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidOutputReceiver;
import org.jetbrains.annotations.NotNull;

@ThreadSafe
public final class AndroidLogcatService
implements AndroidDebugBridge.IDeviceChangeListener,
Disposable {
    private final Object myLock = new Object();
    @GuardedBy(value="myLock")
    private final Map<IDevice, List<LogcatListener>> myListeners = new HashMap<IDevice, List<LogcatListener>>();
    @GuardedBy(value="myLock")
    private final Map<IDevice, LogcatBuffer> myLogBuffers = new HashMap<IDevice, LogcatBuffer>();
    @GuardedBy(value="myLock")
    private final Map<IDevice, AndroidLogcatReceiver> myLogReceivers = new HashMap<IDevice, AndroidLogcatReceiver>();
    @GuardedBy(value="myLock")
    private final Map<IDevice, ExecutorService> myExecutors = new HashMap<IDevice, ExecutorService>();

    private static Logger getLog() {
        return Logger.getInstance(AndroidLogcatService.class);
    }

    @NotNull
    public static AndroidLogcatService getInstance() {
        return (AndroidLogcatService)ServiceManager.getService(AndroidLogcatService.class);
    }

    AndroidLogcatService() {
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startReceiving(@NotNull IDevice device) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myLogReceivers.containsKey(device)) {
                return;
            }
            this.connect(device);
            AndroidLogcatReceiver receiver = this.createReceiver(device);
            this.myLogReceivers.put(device, receiver);
            this.myLogBuffers.put(device, new LogcatBuffer());
            ExecutorService executor = this.myExecutors.get(device);
            executor.submit(() -> {
                try {
                    AndroidLogcatService.executeCommandOnDevice(device, "logcat -v long", receiver, 0L, true);
                }
                catch (Exception e) {
                    AndroidLogcatService.getLog().info(String.format("Caught exception when capturing logcat output from the device %1$s. Receiving logcat output from this device will be stopped, and the listeners will be notified with this exception as the last message", device.getName()), (Throwable)e);
                    LogCatHeader dummyHeader = new LogCatHeader(Log.LogLevel.ERROR, 0, 0, "?", "Internal", LogCatTimestamp.ZERO);
                    receiver.notifyLine(dummyHeader, e.getMessage());
                }
            });
        }
    }

    @NotNull
    private AndroidLogcatReceiver createReceiver(final @NotNull IDevice device) {
        LogcatListener logcatListener = new LogcatListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLogLineReceived(@NotNull LogCatMessage line) {
                Object object = AndroidLogcatService.this.myLock;
                synchronized (object) {
                    if (AndroidLogcatService.this.myListeners.containsKey(device)) {
                        for (LogcatListener listener : (List)AndroidLogcatService.this.myListeners.get(device)) {
                            listener.onLogLineReceived(line);
                        }
                    }
                    if (AndroidLogcatService.this.myLogBuffers.containsKey(device)) {
                        ((LogcatBuffer)AndroidLogcatService.this.myLogBuffers.get(device)).addMessage(line);
                    }
                }
            }
        };
        return new AndroidLogcatReceiver(device, logcatListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(@NotNull IDevice device) {
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myExecutors.containsKey(device)) {
                ThreadFactory factory = new ThreadFactoryBuilder().setNameFormat("logcat-" + device.getName()).build();
                this.myExecutors.put(device, Executors.newSingleThreadExecutor(factory));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect(@NotNull IDevice device) {
        Object object = this.myLock;
        synchronized (object) {
            this.stopReceiving(device);
            this.myExecutors.remove(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopReceiving(@NotNull IDevice device) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myLogReceivers.containsKey(device)) {
                this.myLogReceivers.get(device).cancel();
                this.myLogReceivers.remove(device);
                this.myLogBuffers.remove(device);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLogcat(@NotNull IDevice device, @NotNull Project project) {
        Object object = this.myLock;
        synchronized (object) {
            ExecutorService executor = this.myExecutors.get(device);
            if (executor != null) {
                this.stopReceiving(device);
                executor.submit(() -> {
                    try {
                        long timeoutMs = 5000L;
                        AndroidLogcatService.executeCommandOnDevice(device, "logcat -c", new LoggingReceiver(AndroidLogcatService.getLog()), timeoutMs, false);
                    }
                    catch (Exception e) {
                        AndroidLogcatService.getLog().info((Throwable)e);
                        ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)project, (String)("Error: " + e.getMessage()), (String)AndroidBundle.message("android.logcat.error.dialog.title", new Object[0])));
                    }
                    Object object = this.myLock;
                    synchronized (object) {
                        if (this.myListeners.containsKey(device)) {
                            for (LogcatListener listener : this.myListeners.get(device)) {
                                listener.onCleared();
                            }
                        }
                    }
                });
                this.startReceiving(device);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(@NotNull IDevice device, @NotNull LogcatListener listener, boolean addOldLogs) {
        Object object = this.myLock;
        synchronized (object) {
            if (addOldLogs && this.myLogBuffers.containsKey(device)) {
                for (LogCatMessage line : this.myLogBuffers.get(device).getMessages()) {
                    listener.onLogLineReceived(line);
                }
            }
            if (!this.myListeners.containsKey(device)) {
                this.myListeners.put(device, new ArrayList());
            }
            this.myListeners.get(device).add(listener);
            if (device.isOnline()) {
                this.startReceiving(device);
            }
        }
    }

    public void addListener(@NotNull IDevice device, @NotNull LogcatListener listener) {
        this.addListener(device, listener, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(@NotNull IDevice device, @NotNull LogcatListener listener) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myListeners.containsKey(device)) {
                this.myListeners.get(device).remove(listener);
                if (this.myListeners.get(device).isEmpty()) {
                    this.stopReceiving(device);
                }
            }
        }
    }

    public void deviceConnected(@NotNull IDevice device) {
        if (device.isOnline()) {
            this.startReceiving(device);
        }
    }

    public void deviceDisconnected(@NotNull IDevice device) {
        this.disconnect(device);
    }

    public void deviceChanged(@NotNull IDevice device, int changeMask) {
        if (device.isOnline()) {
            this.startReceiving(device);
        } else {
            this.disconnect(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        Object object = this.myLock;
        synchronized (object) {
            for (AndroidLogcatReceiver receiver : this.myLogReceivers.values()) {
                receiver.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.dispose();
        Object object = this.myLock;
        synchronized (object) {
            this.myExecutors.values().forEach(executor -> {
                try {
                    executor.shutdownNow();
                    executor.awaitTermination(5000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    AndroidLogcatService.getLog().info("Error shutting down executor", (Throwable)e);
                }
            });
        }
    }

    private static void executeCommandOnDevice(@NotNull IDevice device, @NotNull String command, @NotNull AndroidOutputReceiver receiver, long timeoutMs, boolean retry) throws IOException, TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException {
        int MAX_RETRIES = 5;
        for (int attempt = 0; retry && attempt < 5; ++attempt) {
            device.executeShellCommand(command, (IShellOutputReceiver)receiver, timeoutMs, TimeUnit.MILLISECONDS);
            if (receiver.isCancelled()) break;
            receiver.invalidate();
        }
    }

    public static interface LogcatListener {
        default public void onLogLineReceived(@NotNull LogCatMessage line) {
        }

        default public void onCleared() {
        }
    }

    private static class LogcatBuffer {
        private int myBufferSize;
        private final LinkedList<LogCatMessage> myMessages = new LinkedList();

        private LogcatBuffer() {
        }

        public void addMessage(@NotNull LogCatMessage message) {
            this.myMessages.add(message);
            this.myBufferSize += message.getMessage().length();
            if (ConsoleBuffer.useCycleBuffer()) {
                while (this.myBufferSize > ConsoleBuffer.getCycleBufferSize()) {
                    this.myBufferSize -= this.myMessages.removeFirst().getMessage().length();
                }
            }
        }

        @NotNull
        public List<LogCatMessage> getMessages() {
            return this.myMessages;
        }
    }
}

