/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.actions.BrowserHelpAction;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.actions.ScreenRecorderAction;
import com.android.tools.idea.ddms.actions.ScreenshotAction;
import com.android.tools.idea.ddms.actions.TerminateVMAction;
import com.android.tools.idea.logcat.AndroidLogFilterModel;
import com.android.tools.idea.logcat.AndroidLogcatFilter;
import com.android.tools.idea.logcat.AndroidLogcatFormatter;
import com.android.tools.idea.logcat.AndroidLogcatPreferences;
import com.android.tools.idea.logcat.AndroidLogcatService;
import com.android.tools.idea.logcat.ConfigureLogcatFormatDialog;
import com.android.tools.idea.logcat.DefaultAndroidLogcatFilter;
import com.android.tools.idea.logcat.EditLogFilterDialog;
import com.android.tools.idea.logcat.FormattedLogcatReceiver;
import com.android.tools.idea.logcat.LogcatFilterProvider;
import com.android.tools.idea.logcat.PersistentAndroidLogFilters;
import com.android.tools.idea.logcat.RegexFilterComponent;
import com.intellij.diagnostic.logging.LogConsoleBase;
import com.intellij.diagnostic.logging.LogFilterModel;
import com.intellij.diagnostic.logging.LogFormatter;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLogcatView
implements Disposable {
    public static final Key<AndroidLogcatView> ANDROID_LOGCAT_VIEW_KEY = Key.create((String)"ANDROID_LOGCAT_VIEW_KEY");
    static final String SELECTED_APP_FILTER = AndroidBundle.message("android.logcat.filters.selected", new Object[0]);
    static final String NO_FILTERS = AndroidBundle.message("android.logcat.filters.none", new Object[0]);
    static final String EDIT_FILTER_CONFIGURATION = AndroidBundle.message("android.logcat.filters.edit", new Object[0]);
    private final Project myProject;
    private final DeviceContext myDeviceContext;
    private final String myToolWindowId;
    private final boolean myHideMonitors;
    private JPanel myPanel;
    private DefaultComboBoxModel myFilterComboBoxModel;
    private volatile IDevice myDevice;
    private final AndroidLogConsole myLogConsole;
    private final FormattedLogcatReceiver myLogcatReceiver;
    private final AndroidLogFilterModel myLogFilterModel;
    @NotNull
    private final AndroidLogcatFilter myNoFilter;

    private void notifyDeviceUpdated(final boolean forceReconnect) {
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (AndroidLogcatView.this.myProject.isDisposed()) {
                    return;
                }
                if (forceReconnect) {
                    if (AndroidLogcatView.this.myDevice != null) {
                        AndroidLogcatService.getInstance().removeListener(AndroidLogcatView.this.myDevice, AndroidLogcatView.this.myLogcatReceiver);
                    }
                    AndroidLogcatView.this.myDevice = null;
                }
                AndroidLogcatView.this.updateLogConsole();
            }
        });
    }

    @NotNull
    public final Project getProject() {
        return this.myProject;
    }

    @NotNull
    public final LogConsoleBase getLogConsole() {
        return this.myLogConsole;
    }

    public AndroidLogcatView(final @NotNull Project project, @NotNull DeviceContext deviceContext, @NotNull String toolWindowId, boolean hideMonitors) {
        this.myDeviceContext = deviceContext;
        this.myProject = project;
        this.myToolWindowId = toolWindowId;
        this.myHideMonitors = hideMonitors;
        this.$$$setupUI$$$();
        Disposer.register((Disposable)this.myProject, (Disposable)this);
        this.myLogFilterModel = new AndroidLogFilterModel(){

            @NotNull
            private AndroidLogcatPreferences getPreferences() {
                return AndroidLogcatPreferences.getInstance(project);
            }

            @Override
            protected void saveLogLevel(String logLevelName) {
                this.getPreferences().TOOL_WINDOW_LOG_LEVEL = logLevelName;
            }

            @Override
            public String getSelectedLogLevelName() {
                return this.getPreferences().TOOL_WINDOW_LOG_LEVEL;
            }

            @Override
            protected void saveConfiguredFilterName(String filterName) {
                this.getPreferences().TOOL_WINDOW_CONFIGURED_FILTER = filterName;
            }
        };
        AndroidLogcatFormatter logFormatter = new AndroidLogcatFormatter(AndroidLogcatPreferences.getInstance(project));
        this.myLogConsole = new AndroidLogConsole(project, this.myLogFilterModel, (LogFormatter)logFormatter);
        this.myLogcatReceiver = new FormattedLogcatReceiver(){

            @Override
            protected void receiveFormattedLogLine(@NotNull String line) {
                AndroidLogcatView.this.myLogConsole.addLogLine(line);
            }

            @Override
            public void onCleared() {
                AndroidLogcatView.this.myLogFilterModel.beginRejectingOldMessages();
                if (AndroidLogcatView.this.myLogConsole.getConsole() != null) {
                    AndroidLogcatView.this.myLogConsole.clear();
                }
            }
        };
        if (deviceContext != null) {
            DeviceContext.DeviceSelectionListener deviceSelectionListener = new DeviceContext.DeviceSelectionListener(){

                @Override
                public void deviceSelected(@Nullable IDevice device) {
                    AndroidLogcatView.this.notifyDeviceUpdated(false);
                }

                @Override
                public void deviceChanged(@NotNull IDevice device, int changeMask) {
                    if (device == AndroidLogcatView.this.myDevice && (changeMask & 1) == 1) {
                        AndroidLogcatView.this.notifyDeviceUpdated(true);
                    }
                }

                @Override
                public void clientSelected(@Nullable Client c) {
                    AndroidLogcatFilter selected = (AndroidLogcatFilter)AndroidLogcatView.this.myFilterComboBoxModel.getSelectedItem();
                    AndroidLogcatView.this.updateDefaultFilters(c != null ? c.getClientData() : null);
                    if (selected != null && AndroidLogcatView.this.myFilterComboBoxModel.getSelectedItem() != selected) {
                        AndroidLogcatView.this.selectFilterByName(selected.getName());
                    }
                }
            };
            deviceContext.addListener(deviceSelectionListener, this);
        }
        this.myNoFilter = new DefaultAndroidLogcatFilter.Builder(NO_FILTERS).build();
        JComponent consoleComponent = this.myLogConsole.getComponent();
        ConsoleView console = this.myLogConsole.getConsole();
        if (console != null) {
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", this.myLogConsole.getOrCreateActions(), false);
            toolbar.setTargetComponent(console.getComponent());
            JComponent tbComp1 = toolbar.getComponent();
            this.myPanel.add((Component)tbComp1, "West");
        }
        this.myPanel.add((Component)consoleComponent, "Center");
        Disposer.register((Disposable)this, (Disposable)this.myLogConsole);
        this.updateLogConsole();
    }

    @NotNull
    public final JPanel createSearchComponent() {
        JPanel panel = new JPanel();
        final ComboBox editFiltersCombo = new ComboBox();
        this.myFilterComboBoxModel = new DefaultComboBoxModel();
        this.myFilterComboBoxModel.addElement(this.myNoFilter);
        this.myFilterComboBoxModel.addElement(EDIT_FILTER_CONFIGURATION);
        this.updateDefaultFilters(null);
        this.updateUserFilters();
        String selectName = AndroidLogcatPreferences.getInstance((Project)this.myProject).TOOL_WINDOW_CONFIGURED_FILTER;
        if (StringUtil.isEmpty((String)selectName)) {
            selectName = this.myDeviceContext != null ? SELECTED_APP_FILTER : NO_FILTERS;
        }
        this.selectFilterByName(selectName);
        editFiltersCombo.setModel((ComboBoxModel)this.myFilterComboBoxModel);
        this.applySelectedFilter();
        editFiltersCombo.addItemListener(new ItemListener(){
            @Nullable
            private AndroidLogcatFilter myLastSelected;

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object item = e.getItem();
                if (e.getStateChange() == 2) {
                    if (item instanceof AndroidLogcatFilter) {
                        this.myLastSelected = (AndroidLogcatFilter)item;
                    }
                } else if (e.getStateChange() == 1) {
                    if (item instanceof AndroidLogcatFilter) {
                        AndroidLogcatView.this.applySelectedFilter();
                    } else {
                        assert (EDIT_FILTER_CONFIGURATION.equals(item));
                        EditLogFilterDialog dialog = new EditLogFilterDialog(AndroidLogcatView.this, this.myLastSelected == null ? null : this.myLastSelected.getName());
                        dialog.setTitle(AndroidBundle.message("android.logcat.new.filter.dialog.title", new Object[0]));
                        if (dialog.showAndGet()) {
                            PersistentAndroidLogFilters.FilterData filterData = dialog.getActiveFilter();
                            AndroidLogcatView.this.updateUserFilters();
                            if (filterData != null) {
                                AndroidLogcatView.this.selectFilterByName(filterData.getName());
                            }
                        } else {
                            editFiltersCombo.setSelectedItem((Object)this.myLastSelected);
                        }
                    }
                }
            }
        });
        editFiltersCombo.setRenderer((ListCellRenderer)new ColoredListCellRenderer<Object>(){

            protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof AndroidLogcatFilter) {
                    this.setBorder(null);
                    this.append(((AndroidLogcatFilter)value).getName());
                } else {
                    this.setBorder(IdeBorderFactory.createBorder((int)8));
                    this.append(value.toString());
                }
            }
        });
        panel.add((Component)editFiltersCombo);
        JPanel searchComponent = new JPanel();
        searchComponent.setLayout(new BoxLayout(searchComponent, 0));
        searchComponent.add(this.myLogConsole.getSearchComponent());
        searchComponent.add(panel);
        return searchComponent;
    }

    private boolean isActive() {
        ToolWindow window = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(this.myToolWindowId);
        return window.isVisible();
    }

    public final void activate() {
        if (this.isActive()) {
            this.updateLogConsole();
        }
        if (this.myLogConsole != null) {
            this.myLogConsole.activate();
        }
    }

    private void updateLogConsole() {
        IDevice device = this.getSelectedDevice();
        if (this.myDevice != device) {
            AndroidLogcatService androidLogcatService = AndroidLogcatService.getInstance();
            if (this.myDevice != null) {
                androidLogcatService.removeListener(this.myDevice, this.myLogcatReceiver);
            }
            if (this.myLogConsole.getConsole() != null) {
                this.myLogConsole.clear();
            }
            this.myLogFilterModel.processingStarted();
            this.myDevice = device;
            androidLogcatService.addListener(this.myDevice, this.myLogcatReceiver, true);
        }
    }

    @Nullable
    public final IDevice getSelectedDevice() {
        if (this.myDeviceContext != null) {
            return this.myDeviceContext.getSelectedDevice();
        }
        return null;
    }

    private void applySelectedFilter() {
        final Object filter = this.myFilterComboBoxModel.getSelectedItem();
        if (filter instanceof AndroidLogcatFilter) {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Applying filter..."){

                public void run(@NotNull ProgressIndicator indicator) {
                    AndroidLogcatView.this.myLogFilterModel.updateLogcatFilter((AndroidLogcatFilter)filter);
                }
            });
        }
    }

    private void updateDefaultFilters(@Nullable ClientData client) {
        int noFilterIndex = this.myFilterComboBoxModel.getIndexOf(this.myNoFilter);
        for (int i = 0; i < noFilterIndex; ++i) {
            this.myFilterComboBoxModel.removeElementAt(0);
        }
        int insertIndex = 0;
        DefaultAndroidLogcatFilter.Builder selectedAppFilterBuilder = new DefaultAndroidLogcatFilter.Builder(SELECTED_APP_FILTER);
        if (client != null) {
            selectedAppFilterBuilder.setPid(client.getPid());
        }
        this.myFilterComboBoxModel.insertElementAt(selectedAppFilterBuilder.build(), insertIndex++);
        for (LogcatFilterProvider filterProvider : (LogcatFilterProvider[])LogcatFilterProvider.EP_NAME.getExtensions()) {
            AndroidLogcatFilter filter = filterProvider.getFilter(client);
            this.myFilterComboBoxModel.insertElementAt(filter, insertIndex++);
        }
    }

    private void updateUserFilters() {
        assert (this.myFilterComboBoxModel.getIndexOf(EDIT_FILTER_CONFIGURATION) >= 0);
        int userFiltersStartIndex = this.myFilterComboBoxModel.getIndexOf(EDIT_FILTER_CONFIGURATION) + 1;
        while (this.myFilterComboBoxModel.getSize() > userFiltersStartIndex) {
            this.myFilterComboBoxModel.removeElementAt(userFiltersStartIndex);
        }
        List<PersistentAndroidLogFilters.FilterData> filters = PersistentAndroidLogFilters.getInstance(this.myProject).getFilters();
        for (PersistentAndroidLogFilters.FilterData filter : filters) {
            String name = filter.getName();
            assert (name != null);
            DefaultAndroidLogcatFilter compiled = DefaultAndroidLogcatFilter.compile(filter, name);
            this.myFilterComboBoxModel.addElement(compiled);
        }
    }

    private void selectFilterByName(String name) {
        for (int i = 0; i < this.myFilterComboBoxModel.getSize(); ++i) {
            Object element = this.myFilterComboBoxModel.getElementAt(i);
            if (!(element instanceof AndroidLogcatFilter) || !((AndroidLogcatFilter)element).getName().equals(name)) continue;
            this.myFilterComboBoxModel.setSelectedItem(element);
            break;
        }
    }

    @NotNull
    public final JPanel getContentPanel() {
        return this.myPanel;
    }

    public final void dispose() {
        if (this.myDevice != null) {
            AndroidLogcatService.getInstance().removeListener(this.myDevice, this.myLogcatReceiver);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(-1, -1));
        ((Component)jPanel).setBackground(new Color(-1));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    final class AndroidLogConsole
    extends LogConsoleBase {
        private final RegexFilterComponent myRegexFilterComponent;
        private final AndroidLogcatPreferences myPreferences;

        public AndroidLogConsole(Project project, AndroidLogFilterModel logFilterModel, LogFormatter logFormatter) {
            super(project, null, "", false, (LogFilterModel)logFilterModel, GlobalSearchScope.allScope((Project)project), logFormatter);
            this.myRegexFilterComponent = new RegexFilterComponent("LOG_FILTER_HISTORY", 5);
            ConsoleView console = this.getConsole();
            if (console instanceof ConsoleViewImpl) {
                ConsoleViewImpl c = (ConsoleViewImpl)console;
                c.addCustomConsoleAction((AnAction)new Separator());
                c.addCustomConsoleAction((AnAction)new MyRestartAction());
                c.addCustomConsoleAction((AnAction)new MyConfigureLogcatHeaderAction());
                if (AndroidLogcatView.this.myHideMonitors) {
                    c.addCustomConsoleAction((AnAction)new Separator());
                    c.addCustomConsoleAction((AnAction)new ScreenshotAction(project, AndroidLogcatView.this.myDeviceContext));
                    c.addCustomConsoleAction((AnAction)new ScreenRecorderAction(project, AndroidLogcatView.this.myDeviceContext));
                    c.addCustomConsoleAction((AnAction)new Separator());
                    c.addCustomConsoleAction((AnAction)new TerminateVMAction(AndroidLogcatView.this.myDeviceContext));
                }
                c.addCustomConsoleAction((AnAction)new Separator());
                c.addCustomConsoleAction((AnAction)new BrowserHelpAction("logcat", "http://developer.android.com/r/studio-ui/am-logcat.html"));
            }
            this.myPreferences = AndroidLogcatPreferences.getInstance(project);
            this.myRegexFilterComponent.setFilter(this.myPreferences.TOOL_WINDOW_CUSTOM_FILTER);
            this.myRegexFilterComponent.setIsRegex(this.myPreferences.TOOL_WINDOW_REGEXP_FILTER);
            this.myRegexFilterComponent.addRegexListener(new RegexFilterComponent.Listener(){

                @Override
                public void filterChanged(RegexFilterComponent filter) {
                    ((AndroidLogConsole)AndroidLogConsole.this).myPreferences.TOOL_WINDOW_CUSTOM_FILTER = filter.getFilter();
                    ((AndroidLogConsole)AndroidLogConsole.this).myPreferences.TOOL_WINDOW_REGEXP_FILTER = filter.isRegex();
                    AndroidLogcatView.this.myLogFilterModel.updateCustomPattern(filter.getPattern());
                }
            });
        }

        public boolean isActive() {
            return AndroidLogcatView.this.isActive();
        }

        public void clearLogcat() {
            if (AndroidLogcatView.this.getSelectedDevice() != null) {
                AndroidLogcatService.getInstance().clearLogcat(AndroidLogcatView.this.getSelectedDevice(), AndroidLogcatView.this.myProject);
            }
        }

        @NotNull
        protected Component getTextFilterComponent() {
            return this.myRegexFilterComponent;
        }

        public void addLogLine(@NotNull String line) {
            super.addMessage(line);
        }

        public void refresh() {
            this.onTextFilterChange();
        }
    }

    private final class MyConfigureLogcatHeaderAction
    extends AnAction {
        public MyConfigureLogcatHeaderAction() {
            super(AndroidBundle.message("android.configure.logcat.header.text", new Object[0]), AndroidBundle.message("android.configure.logcat.header.description", new Object[0]), AllIcons.General.GearPlain);
        }

        public void actionPerformed(AnActionEvent e) {
            ConfigureLogcatFormatDialog dialog = new ConfigureLogcatFormatDialog(AndroidLogcatView.this.myProject);
            if (dialog.showAndGet()) {
                AndroidLogcatView.this.myLogConsole.refresh();
            }
        }
    }

    private final class MyRestartAction
    extends AnAction {
        public MyRestartAction() {
            super(AndroidBundle.message("android.restart.logcat.action.text", new Object[0]), AndroidBundle.message("android.restart.logcat.action.description", new Object[0]), AllIcons.Actions.Restart);
        }

        public void actionPerformed(AnActionEvent e) {
            AndroidLogcatView.this.notifyDeviceUpdated(true);
        }
    }
}

