/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.model;

import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.instantapp.InstantApps;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.MergedManifest;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Key;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetScopedService;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidModuleInfo
extends AndroidFacetScopedService {
    private static final Key<AndroidModuleInfo> KEY = Key.create((String)AndroidModuleInfo.class.getName());

    @NotNull
    public static AndroidModuleInfo getInstance(@NotNull AndroidFacet facet) {
        AndroidModuleInfo androidModuleInfo = (AndroidModuleInfo)facet.getUserData(KEY);
        if (androidModuleInfo == null) {
            Module baseFeature;
            if (facet.getProjectType() == 4 && (baseFeature = InstantApps.findBaseFeature(facet)) != null) {
                androidModuleInfo = AndroidModuleInfo.getInstance(baseFeature);
            }
            if (androidModuleInfo == null) {
                androidModuleInfo = new AndroidModuleInfo(facet);
            }
            facet.putUserData(KEY, androidModuleInfo);
        }
        return androidModuleInfo;
    }

    @Nullable
    public static AndroidModuleInfo getInstance(@NotNull Module module) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        return facet != null ? AndroidModuleInfo.getInstance(facet) : null;
    }

    private AndroidModuleInfo(@NotNull AndroidFacet facet) {
        super(facet);
    }

    public int getModuleMinApi() {
        return this.getMinSdkVersion().getApiLevel();
    }

    @Nullable
    public String getPackage() {
        AndroidFacet facet = this.getFacet();
        AndroidModel androidModel = facet.getAndroidModel();
        if (androidModel != null) {
            return androidModel.getApplicationId();
        }
        return MergedManifest.get(facet).getApplicationId();
    }

    @NotNull
    public AndroidVersion getRuntimeMinSdkVersion() {
        AndroidVersion minSdkVersion;
        AndroidFacet facet = this.getFacet();
        AndroidModel androidModel = facet.getAndroidModel();
        if (androidModel != null && (minSdkVersion = androidModel.getRuntimeMinSdkVersion()) != null) {
            return minSdkVersion;
        }
        return MergedManifest.get(facet).getMinSdkVersion();
    }

    @NotNull
    public AndroidVersion getMinSdkVersion() {
        AndroidVersion minSdkVersion;
        AndroidFacet facet = this.getFacet();
        AndroidModel androidModel = facet.getAndroidModel();
        if (androidModel != null && (minSdkVersion = androidModel.getMinSdkVersion()) != null) {
            return minSdkVersion;
        }
        return MergedManifest.get(facet).getMinSdkVersion();
    }

    @NotNull
    public AndroidVersion getTargetSdkVersion() {
        AndroidVersion targetSdkVersion;
        AndroidFacet facet = this.getFacet();
        AndroidModel androidModel = facet.getAndroidModel();
        if (androidModel != null && (targetSdkVersion = androidModel.getTargetSdkVersion()) != null) {
            return targetSdkVersion;
        }
        return MergedManifest.get(facet).getTargetSdkVersion();
    }

    @Nullable
    public AndroidVersion getBuildSdkVersion() {
        AndroidPlatform platform = AndroidPlatform.getInstance(this.getModule());
        if (platform != null) {
            return platform.getApiVersion();
        }
        return null;
    }

    @Nullable
    public Boolean isDebuggable() {
        Boolean debuggable;
        AndroidFacet facet = this.getFacet();
        AndroidModel androidModel = facet.getAndroidModel();
        if (androidModel != null && (debuggable = androidModel.isDebuggable()) != null) {
            return debuggable;
        }
        return MergedManifest.get(facet).getApplicationDebuggable();
    }

    @NotNull
    public static AndroidVersion getTargetSdkVersion(@Nullable Module module) {
        AndroidModuleInfo moduleInfo;
        AndroidFacet facet;
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null && (moduleInfo = AndroidModuleInfo.getInstance(facet.getModule())) != null) {
            return moduleInfo.getTargetSdkVersion();
        }
        return AndroidVersion.DEFAULT;
    }

    @NotNull
    public static AndroidVersion getMinSdkVersion(@Nullable Module module) {
        AndroidModuleInfo moduleInfo;
        AndroidFacet facet;
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null && (moduleInfo = AndroidModuleInfo.getInstance(facet.getModule())) != null) {
            return moduleInfo.getMinSdkVersion();
        }
        return AndroidVersion.DEFAULT;
    }

    @Override
    protected void onServiceDisposal(@NotNull AndroidFacet facet) {
        facet.putUserData(KEY, null);
    }
}

