/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.model;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.BaseConfig;
import com.android.builder.model.BuildType;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.ProductFlavor;
import com.android.manifmerger.Actions;
import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.ManifestSystemProperty;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.XmlDocument;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.MergedManifest;
import com.android.utils.ILogger;
import com.android.utils.NullLogger;
import com.android.utils.Pair;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

final class ManifestInfo {
    private ManifestInfo() {
    }

    @NotNull
    static MergingReport getMergedManifest(@NotNull AndroidFacet facet, final @NotNull VirtualFile primaryManifestFile, @NotNull List<VirtualFile> flavorAndBuildTypeManifests, final @NotNull List<VirtualFile> libManifests) throws ManifestMerger2.MergeFailureException {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        final File mainManifestFile = VfsUtilCore.virtualToIoFile((VirtualFile)primaryManifestFile);
        ILogger logger = NullLogger.getLogger();
        ManifestMerger2.MergeType mergeType = facet.isAppProject() || facet.getProjectType() == 5 ? ManifestMerger2.MergeType.APPLICATION : ManifestMerger2.MergeType.LIBRARY;
        AndroidModel androidModel = facet.getAndroidModel();
        AndroidModuleModel gradleModel = AndroidModuleModel.get(facet);
        ManifestMerger2.Invoker manifestMergerInvoker = ManifestMerger2.newMerger((File)mainManifestFile, (ILogger)logger, (ManifestMerger2.MergeType)mergeType);
        manifestMergerInvoker.withFeatures(new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.SKIP_BLAME, ManifestMerger2.Invoker.Feature.SKIP_XML_STRING});
        manifestMergerInvoker.addFlavorAndBuildTypeManifests(VfsUtilCore.virtualToIoFiles(flavorAndBuildTypeManifests).toArray(new File[0]));
        ArrayList<Pair> libraryManifests = new ArrayList<Pair>();
        for (VirtualFile file : libManifests) {
            libraryManifests.add(Pair.of((Object)file.getName(), (Object)VfsUtilCore.virtualToIoFile((VirtualFile)file)));
        }
        manifestMergerInvoker.addBundleManifests(libraryManifests);
        if (androidModel != null) {
            String packageOverride;
            Integer versionCode;
            AndroidVersion targetSdkVersion;
            AndroidVersion minSdkVersion = androidModel.getMinSdkVersion();
            if (minSdkVersion != null) {
                manifestMergerInvoker.setOverride(ManifestSystemProperty.MIN_SDK_VERSION, minSdkVersion.getApiString());
            }
            if ((targetSdkVersion = androidModel.getTargetSdkVersion()) != null) {
                manifestMergerInvoker.setOverride(ManifestSystemProperty.TARGET_SDK_VERSION, targetSdkVersion.getApiString());
            }
            if ((versionCode = androidModel.getVersionCode()) != null && versionCode > 0) {
                manifestMergerInvoker.setOverride(ManifestSystemProperty.VERSION_CODE, String.valueOf(versionCode));
            }
            if (!Strings.isNullOrEmpty((String)(packageOverride = androidModel.getApplicationId()))) {
                manifestMergerInvoker.setOverride(ManifestSystemProperty.PACKAGE, packageOverride);
            }
        }
        if (gradleModel != null) {
            BuildTypeContainer buildTypeContainer = gradleModel.findBuildType(gradleModel.getSelectedVariant().getBuildType());
            assert (buildTypeContainer != null);
            BuildType buildType = buildTypeContainer.getBuildType();
            ProductFlavor mergedProductFlavor = gradleModel.getSelectedVariant().getMergedFlavor();
            HashMap placeHolders = new HashMap(mergedProductFlavor.getManifestPlaceholders());
            placeHolders.putAll(buildType.getManifestPlaceholders());
            manifestMergerInvoker.setPlaceHolderValues(placeHolders);
            Integer maxSdkVersion = mergedProductFlavor.getMaxSdkVersion();
            if (maxSdkVersion != null) {
                manifestMergerInvoker.setOverride(ManifestSystemProperty.MAX_SDK_VERSION, maxSdkVersion.toString());
            }
            String versionName = mergedProductFlavor.getVersionName();
            String flavorVersionNameSuffix = null;
            if (gradleModel.getFeatures().isProductFlavorVersionSuffixSupported()) {
                flavorVersionNameSuffix = ManifestInfo.getVersionNameSuffix((BaseConfig)mergedProductFlavor);
            }
            String versionNameSuffix = Joiner.on((String)"").skipNulls().join((Object)flavorVersionNameSuffix, (Object)ManifestInfo.getVersionNameSuffix((BaseConfig)buildType), new Object[0]);
            if (!Strings.isNullOrEmpty((String)versionName) || !Strings.isNullOrEmpty((String)versionNameSuffix)) {
                Manifest manifest;
                if (Strings.isNullOrEmpty((String)versionName) && (manifest = facet.getManifest()) != null) {
                    versionName = manifest.getXmlTag().getAttributeValue("versionName", "http://schemas.android.com/apk/res/android");
                }
                if (!Strings.isNullOrEmpty((String)versionNameSuffix)) {
                    versionName = Strings.nullToEmpty((String)versionName) + versionNameSuffix;
                }
                manifestMergerInvoker.setOverride(ManifestSystemProperty.VERSION_NAME, versionName);
            }
        }
        if (mergeType == ManifestMerger2.MergeType.APPLICATION) {
            manifestMergerInvoker.withFeatures(new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.REMOVE_TOOLS_DECLARATIONS});
        }
        final Module module = facet.getModule();
        final Project project = module.getProject();
        manifestMergerInvoker.withFileStreamProvider(new ManifestMerger2.FileStreamProvider(){

            protected InputStream getInputStream(@NotNull File file) throws FileNotFoundException {
                MergedManifest manifest;
                Document document;
                Module moduleContainingManifest;
                VirtualFile vFile = file == mainManifestFile ? primaryManifestFile : VfsUtil.findFileByIoFile((File)file, (boolean)false);
                if (vFile == null) {
                    return new ByteArrayInputStream("<manifest/>".getBytes(StandardCharsets.UTF_8));
                }
                if (!libManifests.isEmpty() && (moduleContainingManifest = this.getAndroidModuleForManifest(vFile)) != null && !module.equals(moduleContainingManifest) && (document = (manifest = MergedManifest.get(moduleContainingManifest)).getDocument()) != null) {
                    String text = XmlUtils.toXml((Node)document);
                    return new ByteArrayInputStream(text.getBytes(Charsets.UTF_8));
                }
                try {
                    PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(vFile);
                    if (psiFile != null) {
                        String text = psiFile.getText();
                        return new ByteArrayInputStream(text.getBytes(Charsets.UTF_8));
                    }
                }
                catch (ProcessCanceledException processCanceledException) {
                    // empty catch block
                }
                return super.getInputStream(file);
            }

            @Nullable
            private Module getAndroidModuleForManifest(@NotNull VirtualFile vFile) {
                for (Module m : ModuleManager.getInstance((Project)project).getModules()) {
                    AndroidFacet androidFacet = AndroidFacet.getInstance(m);
                    if (androidFacet == null) continue;
                    List<VirtualFile> manifestFiles = IdeaSourceProvider.getManifestFiles(androidFacet);
                    for (VirtualFile manifestFile : manifestFiles) {
                        if (!vFile.equals(manifestFile)) continue;
                        return m;
                    }
                }
                return null;
            }
        });
        return manifestMergerInvoker.merge();
    }

    @Deprecated
    @Nullable
    private static String getVersionNameSuffix(@NotNull BaseConfig config) {
        try {
            return config.getVersionNameSuffix();
        }
        catch (UnsupportedMethodException e) {
            Logger.getInstance(ManifestInfo.class).warn("Method 'getVersionNameSuffix' not found", (Throwable)e);
            return null;
        }
    }

    static class ManifestFile {
        @NotNull
        private final AndroidFacet myFacet;
        @Nullable
        private Document myDocument;
        @Nullable
        private List<VirtualFile> myManifestFiles;
        @Nullable
        private Map<Object, Long> myLastModifiedMap;
        @Nullable
        private ImmutableList<MergingReport.Record> myLoggingRecords;
        @Nullable
        private Actions myActions;

        private ManifestFile(@NotNull AndroidFacet facet) {
            this.myFacet = facet;
        }

        @NotNull
        public static ManifestFile create(@NotNull AndroidFacet facet) {
            return new ManifestFile(facet);
        }

        @Nullable
        private Document parseManifest(@NotNull VirtualFile primaryManifestFile, @NotNull List<VirtualFile> flavorAndBuildTypeManifests, @NotNull List<VirtualFile> libManifests) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            Project project = this.myFacet.getModule().getProject();
            if (project.isDisposed()) {
                return null;
            }
            try {
                MergingReport mergingReport = ManifestInfo.getMergedManifest(this.myFacet, primaryManifestFile, flavorAndBuildTypeManifests, libManifests);
                this.myLoggingRecords = mergingReport.getLoggingRecords();
                this.myActions = mergingReport.getActions();
                XmlDocument doc = mergingReport.getMergedXmlDocument(MergingReport.MergedManifestKind.MERGED);
                if (doc != null) {
                    return doc.getXml();
                }
                Logger.getInstance(ManifestInfo.class).warn("getMergedManifest failed " + mergingReport.getReportString());
            }
            catch (ManifestMerger2.MergeFailureException ex) {
                if (ex.getCause() instanceof ProcessCanceledException) {
                    return null;
                }
                if (ex.getCause() instanceof SAXParseException) {
                    return null;
                }
                Logger.getInstance(ManifestInfo.class).warn("getMergedManifest exception", (Throwable)ex);
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(primaryManifestFile);
            if (psiFile != null) {
                String text = psiFile.getText();
                return XmlUtils.parseDocumentSilently((String)text, (boolean)true);
            }
            return null;
        }

        public boolean refresh() {
            HashMap<Object, Long> lastModifiedMap = new HashMap<Object, Long>();
            VirtualFile primaryManifestFile = AndroidRootUtil.getPrimaryManifestFile(this.myFacet);
            if (primaryManifestFile == null) {
                return false;
            }
            lastModifiedMap.put(primaryManifestFile, this.getFileModificationStamp(primaryManifestFile));
            Project project = this.myFacet.getModule().getProject();
            long lastGradleSyncTimestamp = GradleSyncState.getInstance(project).getSummary().getSyncTimestamp();
            lastModifiedMap.put("gradle-sync", lastGradleSyncTimestamp);
            List<VirtualFile> flavorAndBuildTypeManifests = ManifestFile.getFlavorAndBuildTypeManifests(this.myFacet);
            this.trackChanges(lastModifiedMap, flavorAndBuildTypeManifests);
            List<VirtualFile> libraryManifests = Collections.emptyList();
            if (this.myFacet.isAppProject() || this.myFacet.getProjectType() == 5) {
                libraryManifests = ManifestFile.getLibManifests(this.myFacet);
                this.trackChanges(lastModifiedMap, libraryManifests);
            }
            ArrayList<VirtualFile> flavorAndBuildTypeManifestsOfLibs = new ArrayList<VirtualFile>();
            List<AndroidFacet> dependencies2 = AndroidUtils.getAllAndroidDependencies(this.myFacet.getModule(), true);
            for (AndroidFacet dependency : dependencies2) {
                flavorAndBuildTypeManifestsOfLibs.addAll(ManifestFile.getFlavorAndBuildTypeManifests(dependency));
            }
            this.trackChanges(lastModifiedMap, flavorAndBuildTypeManifestsOfLibs);
            if (this.myDocument == null || !lastModifiedMap.equals(this.myLastModifiedMap)) {
                this.myDocument = this.parseManifest(primaryManifestFile, flavorAndBuildTypeManifests, libraryManifests);
                if (this.myDocument == null) {
                    this.myManifestFiles = null;
                    return false;
                }
                this.myManifestFiles = Lists.newArrayList();
                this.myManifestFiles.add(primaryManifestFile);
                this.myManifestFiles.addAll(flavorAndBuildTypeManifests);
                this.myManifestFiles.addAll(libraryManifests);
                this.myLastModifiedMap = lastModifiedMap;
                return true;
            }
            return false;
        }

        private void trackChanges(@NotNull Map<Object, Long> lastModifiedMap, @NotNull List<VirtualFile> files) {
            for (VirtualFile libraryManifest : files) {
                lastModifiedMap.put(libraryManifest, this.getFileModificationStamp(libraryManifest));
            }
        }

        @NotNull
        private static List<VirtualFile> getFlavorAndBuildTypeManifests(@NotNull AndroidFacet facet) {
            ArrayList<VirtualFile> flavorAndBuildTypeManifests = new ArrayList<VirtualFile>();
            IdeaSourceProvider defaultSourceProvider = facet.getMainIdeaSourceProvider();
            for (IdeaSourceProvider provider : IdeaSourceProvider.getCurrentSourceProviders(facet)) {
                VirtualFile flavorOrBuildTypeManifest;
                if (defaultSourceProvider.equals(provider) || (flavorOrBuildTypeManifest = provider.getManifestFile()) == null) continue;
                flavorAndBuildTypeManifests.add(flavorOrBuildTypeManifest);
            }
            return flavorAndBuildTypeManifests;
        }

        @NotNull
        private static List<VirtualFile> getLibManifests(@NotNull AndroidFacet facet) {
            ArrayList<VirtualFile> libraryManifests = new ArrayList<VirtualFile>();
            List<AndroidFacet> dependencies2 = AndroidUtils.getAllAndroidDependencies(facet.getModule(), true);
            AndroidModuleModel androidModuleModel = AndroidModuleModel.get(facet);
            if (androidModuleModel != null) {
                Collection libraries = androidModuleModel.getSelectedMainCompileDependencies().getLibraries();
                HashSet<File> set = new HashSet<File>();
                for (AndroidLibrary dependency : libraries) {
                    ManifestFile.addAarManifests(dependency, set, dependencies2);
                }
                for (File file : set) {
                    VirtualFile libraryManifest = VfsUtil.findFileByIoFile((File)file, (boolean)false);
                    if (libraryManifest == null) continue;
                    libraryManifests.add(libraryManifest);
                }
            }
            for (AndroidFacet dependency : dependencies2) {
                VirtualFile vFile = dependency.getMainIdeaSourceProvider().getManifestFile();
                if (vFile == null) continue;
                libraryManifests.add(vFile);
            }
            return libraryManifests;
        }

        private static void addAarManifests(@NotNull AndroidLibrary lib, @NotNull Set<File> result, @NotNull List<AndroidFacet> moduleDeps) {
            String projectName = lib.getProject();
            if (projectName != null) {
                for (AndroidFacet f : moduleDeps) {
                    if (!projectName.equals(GradleUtil.getGradlePath(f.getModule()))) continue;
                    return;
                }
            }
            if (!result.contains(lib.getManifest())) {
                result.add(lib.getManifest());
                for (AndroidLibrary dependency : lib.getLibraryDependencies()) {
                    ManifestFile.addAarManifests(dependency, result, moduleDeps);
                }
            }
        }

        private long getFileModificationStamp(@NotNull VirtualFile file) {
            try {
                PsiFile psiFile = PsiManager.getInstance((Project)this.myFacet.getModule().getProject()).findFile(file);
                return psiFile == null ? file.getModificationStamp() : psiFile.getModificationStamp();
            }
            catch (ProcessCanceledException ignore) {
                return 0L;
            }
        }

        public Document getXmlDocument() {
            return this.myDocument;
        }

        @Nullable
        public List<VirtualFile> getManifestFiles() {
            return this.myManifestFiles;
        }

        @NotNull
        public ImmutableList<MergingReport.Record> getLoggingRecords() {
            return this.myLoggingRecords == null ? ImmutableList.of() : this.myLoggingRecords;
        }

        @Nullable
        public Actions getActions() {
            return this.myActions;
        }
    }
}

