/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.model;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.manifmerger.Actions;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.XmlNode;
import com.android.resources.ScreenSize;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.devices.Device;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.ManifestInfo;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.android.tools.idea.run.activity.ActivityLocatorUtils;
import com.android.tools.lint.checks.PermissionHolder;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MergedManifest {
    private final Module myModule;
    private String myPackage;
    private String myApplicationId;
    private Integer myVersionCode;
    private String myManifestTheme;
    private Map<String, ActivityAttributes> myActivityAttributesMap;
    private ManifestInfo.ManifestFile myManifestFile;
    private long myLastChecked;
    private AndroidVersion myMinSdk;
    private AndroidVersion myTargetSdk;
    private String myApplicationIcon;
    private String myApplicationLabel;
    private boolean myApplicationSupportsRtl;
    private Boolean myApplicationDebuggable;
    @Nullable
    private Map<String, XmlNode.NodeKey> myNodeKeys;
    private Document myDocument;
    private List<VirtualFile> myManifestFiles;
    private ModulePermissions myPermissionHolder;
    private boolean myApplicationHasCode = true;
    private List<Element> myActivities = Collections.emptyList();
    private List<Element> myActivityAliases = Collections.emptyList();
    private List<Element> myServices = Collections.emptyList();

    MergedManifest(@NotNull Module module) {
        this.myModule = module;
    }

    @NotNull
    public static MergedManifest get(@NotNull Module module) {
        if (module.isDisposed()) {
            return new MergedManifest(module){

                @Override
                protected void syncWithReadPermission() {
                }
            };
        }
        MergedManifest manifest = (MergedManifest)module.getComponent(MergedManifest.class);
        assert (manifest != null);
        return manifest;
    }

    @NotNull
    public static MergedManifest get(@NotNull AndroidFacet facet) {
        return MergedManifest.get(facet.getModule());
    }

    @Nullable
    public Document getDocument() {
        this.sync();
        return this.myDocument;
    }

    @Nullable
    public List<VirtualFile> getManifestFiles() {
        return this.myManifestFiles;
    }

    public void clear() {
        this.myLastChecked = 0L;
    }

    @Nullable
    public String getPackage() {
        this.sync();
        return this.myPackage;
    }

    @Nullable
    public String getApplicationId() {
        this.sync();
        return this.myApplicationId;
    }

    @Nullable
    public Integer getVersionCode() {
        this.sync();
        return this.myVersionCode;
    }

    @NotNull
    public Map<String, ActivityAttributes> getActivityAttributesMap() {
        this.sync();
        if (this.myActivityAttributesMap == null) {
            return Collections.emptyMap();
        }
        return this.myActivityAttributesMap;
    }

    @Nullable
    public ActivityAttributes getActivityAttributes(@NotNull String activity) {
        int index = activity.indexOf(46);
        if (index <= 0 && this.myApplicationId != null && !this.myApplicationId.isEmpty()) {
            activity = this.myApplicationId + (index == -1 ? "." : "") + activity;
        }
        return this.getActivityAttributesMap().get(activity);
    }

    @Nullable
    public String getManifestTheme() {
        this.sync();
        return this.myManifestTheme;
    }

    @NotNull
    public String getDefaultTheme(@Nullable IAndroidTarget renderingTarget, @Nullable ScreenSize screenSize, @Nullable Device device) {
        int targetSdk;
        this.sync();
        if (this.myManifestTheme != null) {
            return this.myManifestTheme;
        }
        if (device != null) {
            if (HardwareConfigHelper.isWear((Device)device)) {
                return "@android:style/Theme.DeviceDefault.Light";
            }
            if (HardwareConfigHelper.isTv((Device)device)) {
                return "@style/Theme.Leanback";
            }
        }
        AndroidFacet facet = AndroidFacet.getInstance(this.myModule);
        assert (facet != null);
        AndroidModuleInfo info = AndroidModuleInfo.getInstance(facet);
        int renderingTargetSdk = targetSdk = info.getTargetSdkVersion().getApiLevel();
        if (renderingTarget instanceof CompatibilityRenderTarget) {
            renderingTargetSdk = renderingTarget.getVersion().getApiLevel();
        } else if (renderingTarget != null) {
            renderingTargetSdk = renderingTarget.getVersion().getApiLevel();
        }
        int apiLevel = Math.min(targetSdk, renderingTargetSdk);
        if (apiLevel >= 21) {
            return "@android:style/Theme.Material.Light";
        }
        if (apiLevel >= 14 || apiLevel >= 11 && screenSize == ScreenSize.XLARGE) {
            return "@android:style/Theme.Holo";
        }
        return "@android:style/Theme";
    }

    @Nullable
    public String getApplicationIcon() {
        this.sync();
        return this.myApplicationIcon;
    }

    @Nullable
    public String getApplicationLabel() {
        this.sync();
        return this.myApplicationLabel;
    }

    public boolean isRtlSupported() {
        this.sync();
        return this.myApplicationSupportsRtl;
    }

    @Nullable
    public Boolean getApplicationDebuggable() {
        this.sync();
        return this.myApplicationDebuggable;
    }

    public boolean getApplicationHasCode() {
        this.sync();
        return this.myApplicationHasCode;
    }

    @NotNull
    public AndroidVersion getTargetSdkVersion() {
        this.sync();
        return this.myTargetSdk != null ? this.myTargetSdk : this.getMinSdkVersion();
    }

    @NotNull
    public AndroidVersion getMinSdkVersion() {
        this.sync();
        return this.myMinSdk != null ? this.myMinSdk : AndroidVersion.DEFAULT;
    }

    @NotNull
    public PermissionHolder getPermissionHolder() {
        this.sync();
        if (this.myPermissionHolder == null) {
            return new ModulePermissions(Collections.emptySet(), Collections.emptySet());
        }
        return this.myPermissionHolder;
    }

    private void sync() {
        long now = System.currentTimeMillis();
        if (now - this.myLastChecked < 50L && this.myManifestFile != null) {
            return;
        }
        this.myLastChecked = now;
        ApplicationManager.getApplication().runReadAction(this::syncWithReadPermission);
    }

    static String getAttributeValue(@NotNull Element element, @Nullable String namespace, @NotNull String localName) {
        return Strings.emptyToNull((String)element.getAttributeNS(namespace, localName));
    }

    protected synchronized void syncWithReadPermission() {
        boolean refresh;
        AndroidFacet facet = AndroidFacet.getInstance(this.myModule);
        assert (facet != null) : "Attempt to obtain manifest info from a non Android module: " + this.myModule.getName();
        if (this.myManifestFile == null) {
            this.myManifestFile = ManifestInfo.ManifestFile.create(facet);
        }
        if (!(refresh = this.myManifestFile.refresh())) {
            return;
        }
        this.myActivityAttributesMap = new HashMap<String, ActivityAttributes>();
        this.myManifestTheme = null;
        this.myTargetSdk = AndroidVersion.DEFAULT;
        this.myMinSdk = AndroidVersion.DEFAULT;
        this.myPackage = "";
        this.myApplicationId = "";
        this.myVersionCode = null;
        this.myApplicationIcon = null;
        this.myApplicationLabel = null;
        this.myApplicationSupportsRtl = false;
        this.myNodeKeys = null;
        this.myActivities = Lists.newArrayList();
        this.myActivityAliases = Lists.newArrayListWithExpectedSize((int)4);
        this.myServices = Lists.newArrayListWithExpectedSize((int)4);
        HashSet permissions = Sets.newHashSetWithExpectedSize((int)30);
        HashSet revocable = Sets.newHashSetWithExpectedSize((int)2);
        try {
            Document document = this.myManifestFile.getXmlDocument();
            if (document == null) {
                return;
            }
            this.myDocument = document;
            this.myManifestFiles = this.myManifestFile.getManifestFiles();
            Element root = document.getDocumentElement();
            if (root == null) {
                return;
            }
            this.myApplicationId = MergedManifest.getAttributeValue(root, null, "package");
            Manifest manifest = facet.getManifest();
            this.myPackage = manifest == null ? this.myApplicationId : (String)manifest.getPackage().getValue();
            String versionCode = MergedManifest.getAttributeValue(root, "http://schemas.android.com/apk/res/android", "versionCode");
            try {
                this.myVersionCode = Integer.valueOf(versionCode);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
                String name;
                String protectionLevel;
                Element element;
                if (node.getNodeType() != 1) continue;
                String nodeName = node.getNodeName();
                if ("application".equals(nodeName)) {
                    Element application = (Element)node;
                    this.myApplicationIcon = MergedManifest.getAttributeValue(application, "http://schemas.android.com/apk/res/android", "icon");
                    this.myApplicationLabel = MergedManifest.getAttributeValue(application, "http://schemas.android.com/apk/res/android", "label");
                    this.myManifestTheme = MergedManifest.getAttributeValue(application, "http://schemas.android.com/apk/res/android", "theme");
                    this.myApplicationSupportsRtl = "true".equals(MergedManifest.getAttributeValue(application, "http://schemas.android.com/apk/res/android", "supportsRtl"));
                    String debuggable = MergedManifest.getAttributeValue(application, "http://schemas.android.com/apk/res/android", "debuggable");
                    this.myApplicationDebuggable = debuggable == null ? null : Boolean.valueOf("true".equals(debuggable));
                    String hasCode = MergedManifest.getAttributeValue(application, "http://schemas.android.com/apk/res/android", "hasCode");
                    this.myApplicationHasCode = hasCode == null ? true : "true".equals(hasCode);
                    for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                        if (child.getNodeType() != 1) continue;
                        String childNodeName = child.getNodeName();
                        if ("activity".equals(childNodeName)) {
                            Element element2 = (Element)child;
                            ActivityAttributes attributes = new ActivityAttributes(element2, this.myApplicationId);
                            this.myActivityAttributesMap.put(attributes.getName(), attributes);
                            this.myActivities.add(element2);
                            continue;
                        }
                        if ("activity-alias".equals(childNodeName)) {
                            this.myActivityAliases.add((Element)child);
                            continue;
                        }
                        if (!"service".equals(childNodeName)) continue;
                        this.myServices.add((Element)child);
                    }
                    continue;
                }
                if ("uses-sdk".equals(nodeName)) {
                    Element usesSdk = (Element)node;
                    this.myMinSdk = MergedManifest.getApiVersion(usesSdk, "minSdkVersion", AndroidVersion.DEFAULT);
                    this.myTargetSdk = MergedManifest.getApiVersion(usesSdk, "targetSdkVersion", this.myMinSdk);
                    continue;
                }
                if ("uses-permission".equals(nodeName) || "uses-permission-sdk-23".equals(nodeName) || "uses-permission-sdk-m".equals(nodeName)) {
                    element = (Element)node;
                    String name2 = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                    if (name2.isEmpty()) continue;
                    permissions.add(name2);
                    continue;
                }
                if (!nodeName.equals("permission") || !"dangerous".equals(protectionLevel = (element = (Element)node).getAttributeNS("http://schemas.android.com/apk/res/android", "protectionLevel")) || (name = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name")).isEmpty()) continue;
                revocable.add(name);
            }
            this.myPermissionHolder = new ModulePermissions((Set)ImmutableSet.copyOf((Collection)permissions), (Set)ImmutableSet.copyOf((Collection)revocable));
        }
        catch (ProcessCanceledException e) {
            this.myManifestFile = null;
            this.myDocument = null;
            throw e;
        }
        catch (Exception e) {
            Logger.getInstance(MergedManifest.class).warn("Could not read Manifest data", (Throwable)e);
        }
    }

    private static AndroidVersion getApiVersion(Element usesSdk, String attribute, AndroidVersion defaultApiLevel) {
        AndroidVersion version;
        String valueString = MergedManifest.getAttributeValue(usesSdk, "http://schemas.android.com/apk/res/android", attribute);
        if (valueString != null && (version = SdkVersionInfo.getVersion((String)valueString, null)) != null) {
            return version;
        }
        return defaultApiLevel;
    }

    @NotNull
    public List<Element> getActivities() {
        this.sync();
        return this.myActivities;
    }

    @NotNull
    public List<Element> getActivityAliases() {
        this.sync();
        return this.myActivityAliases;
    }

    @NotNull
    public List<Element> getServices() {
        return this.myServices;
    }

    @Nullable
    public Element findUsedFeature(@NotNull String name) {
        this.sync();
        if (this.myDocument == null) {
            return null;
        }
        for (Node node = this.myDocument.getDocumentElement().getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element;
            if (node.getNodeType() != 1 || !"uses-feature".equals(node.getNodeName()) || !name.equals((element = (Element)node).getAttributeNS("http://schemas.android.com/apk/res/android", "name"))) continue;
            return element;
        }
        return null;
    }

    @NotNull
    public ImmutableList<MergingReport.Record> getLoggingRecords() {
        this.sync();
        return this.myManifestFile == null ? ImmutableList.of() : this.myManifestFile.getLoggingRecords();
    }

    @Nullable
    public Actions getActions() {
        this.sync();
        return this.myManifestFile == null ? null : this.myManifestFile.getActions();
    }

    @Nullable
    public XmlNode.NodeKey getNodeKey(String name) {
        this.sync();
        if (this.myNodeKeys == null) {
            HashMap<String, XmlNode.NodeKey> nodeKeys = new HashMap<String, XmlNode.NodeKey>();
            Actions actions = this.getActions();
            if (actions != null) {
                Set keys = actions.getNodeKeys();
                for (XmlNode.NodeKey key : keys) {
                    nodeKeys.put(key.toString(), key);
                }
            }
            this.myNodeKeys = nodeKeys;
        }
        return this.myNodeKeys.get(name);
    }

    @Nullable
    public Element findActivity(@Nullable String qualifiedName) {
        this.sync();
        if (qualifiedName == null || this.myActivities == null) {
            return null;
        }
        return MergedManifest.getActivityOrAliasByName(qualifiedName, this.myActivities);
    }

    @Nullable
    public Element findActivityAlias(@Nullable String qualifiedName) {
        this.sync();
        if (qualifiedName == null || this.myActivityAliases == null) {
            return null;
        }
        return MergedManifest.getActivityOrAliasByName(qualifiedName, this.myActivityAliases);
    }

    @Nullable
    private static Element getActivityOrAliasByName(@NotNull String qualifiedName, @NotNull List<Element> activityOrAliasElements) {
        for (Element activity : activityOrAliasElements) {
            if (!qualifiedName.equals(ActivityLocatorUtils.getQualifiedName(activity))) continue;
            return activity;
        }
        return null;
    }

    @NotNull
    public Module getModule() {
        return this.myModule;
    }

    private class ModulePermissions
    implements PermissionHolder {
        @NotNull
        private final Set<String> myPermissions;
        @NotNull
        private final Set<String> myRevocable;

        private ModulePermissions(@NotNull Set<String> permissions, Set<String> revocable) {
            this.myPermissions = permissions;
            this.myRevocable = revocable;
        }

        public boolean hasPermission(@NotNull String permission) {
            return this.myPermissions.contains(permission);
        }

        public boolean isRevocable(@NotNull String permission) {
            return this.myRevocable.contains(permission);
        }

        @NotNull
        public AndroidVersion getMinSdkVersion() {
            AndroidModuleInfo androidModuleInfo = AndroidModuleInfo.getInstance(MergedManifest.this.myModule);
            return androidModuleInfo != null ? androidModuleInfo.getMinSdkVersion() : MergedManifest.this.getMinSdkVersion();
        }

        @NotNull
        public AndroidVersion getTargetSdkVersion() {
            AndroidModuleInfo androidModuleInfo = AndroidModuleInfo.getInstance(MergedManifest.this.myModule);
            return androidModuleInfo != null ? androidModuleInfo.getTargetSdkVersion() : MergedManifest.this.getTargetSdkVersion();
        }
    }

    public static class ActivityAttributes {
        @NotNull
        private final Element myElement;
        @Nullable
        private final String myIcon;
        @Nullable
        private final String myLabel;
        @NotNull
        private final String myName;
        @Nullable
        private final String myParentActivity;
        @Nullable
        private final String myTheme;
        @Nullable
        private final String myUiOptions;

        public ActivityAttributes(@NotNull Element activity, @Nullable String packageName) {
            this.myElement = activity;
            String name = MergedManifest.getAttributeValue(activity, "http://schemas.android.com/apk/res/android", "name");
            if (name == null || name.isEmpty()) {
                throw new RuntimeException("Activity name cannot be empty.");
            }
            int index = name.indexOf(46);
            if (index <= 0 && packageName != null && !packageName.isEmpty()) {
                name = packageName + (index == -1 ? "." : "") + name;
            }
            this.myName = name;
            String value = MergedManifest.getAttributeValue(activity, "http://schemas.android.com/apk/res/android", "icon");
            this.myIcon = value != null && !value.isEmpty() ? value : null;
            value = MergedManifest.getAttributeValue(activity, "http://schemas.android.com/apk/res/android", "label");
            this.myLabel = value != null && !value.isEmpty() ? value : null;
            value = MergedManifest.getAttributeValue(activity, "http://schemas.android.com/apk/res/android", "parentActivityName");
            if (value == null || value.isEmpty()) {
                for (Node child = activity.getFirstChild(); child != null; child = child.getNextSibling()) {
                    String metaDataName;
                    if (child.getNodeType() != 1 || !child.getNodeName().equals("meta-data") || !"android.support.PARENT_ACTIVITY".equals(metaDataName = MergedManifest.getAttributeValue((Element)child, "http://schemas.android.com/apk/res/android", "name")) || (value = MergedManifest.getAttributeValue(activity, "http://schemas.android.com/apk/res/android", "value")) == null || (index = value.indexOf(46)) > 0 || packageName == null || packageName.isEmpty()) continue;
                    value = packageName + (index == -1 ? "." : "") + value;
                    break;
                }
            }
            this.myParentActivity = value != null && !value.isEmpty() ? value : null;
            value = MergedManifest.getAttributeValue(activity, "http://schemas.android.com/apk/res/android", "theme");
            this.myTheme = value != null && !value.isEmpty() ? value : null;
            value = MergedManifest.getAttributeValue(activity, "http://schemas.android.com/apk/res/android", "uiOptions");
            this.myUiOptions = value != null && !value.isEmpty() ? value : null;
        }

        @NotNull
        public Element getElement() {
            return this.myElement;
        }

        @Nullable
        public String getIcon() {
            return this.myIcon;
        }

        @Nullable
        public String getLabel() {
            return this.myLabel;
        }

        @NotNull
        public String getName() {
            return this.myName;
        }

        @Nullable
        public String getParentActivity() {
            return this.myParentActivity;
        }

        @Nullable
        public String getTheme() {
            return this.myTheme;
        }

        @Nullable
        public String getUiOptions() {
            return this.myUiOptions;
        }
    }
}

