/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor;

import com.android.ddmlib.Client;
import com.android.tools.adtui.TimelineData;
import com.android.tools.idea.monitor.TimelineEventListener;
import com.intellij.openapi.application.ApplicationManager;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeviceSampler {
    public static final int TYPE_UNREACHABLE = 0;
    public static final int TYPE_DATA = 1;
    public static final int TYPE_TIMEOUT = 2;
    public static final int INHERITED_TYPE_START = 3;
    @NotNull
    protected final List<TimelineEventListener> myListeners = new ArrayList<TimelineEventListener>();
    protected final int mySampleFrequencyMs;
    @NotNull
    private volatile TimelineData myTimelineData;
    @Nullable
    private volatile Client myClient;
    @NotNull
    private final Semaphore myDataSemaphore;
    @Nullable
    private volatile CountDownLatch myTaskFinished;
    @Nullable
    private volatile Future<?> myExecutingTask;
    private volatile boolean myRunning;
    private volatile boolean myIsPaused;

    public DeviceSampler(@NotNull TimelineData timelineData, int sampleFrequencyMs) {
        this.myTimelineData = timelineData;
        this.mySampleFrequencyMs = sampleFrequencyMs;
        this.myDataSemaphore = new Semaphore(0, true);
    }

    public void start() {
        this.startSamplingTask();
    }

    public void stop() {
        this.stopSamplingTask();
    }

    @NotNull
    public final TimelineData getTimelineData() {
        return this.myTimelineData;
    }

    public final void setTimelineData(@NotNull TimelineData timelineData) {
        this.myTimelineData = timelineData;
    }

    public final synchronized void setClient(@Nullable Client client) {
        if (this.requiresSamplerRestart(client)) {
            this.stop();
            this.myClient = client;
            this.prepareSampler();
            this.myTimelineData.clear();
            if (!this.myIsPaused) {
                this.start();
            }
        }
    }

    public final synchronized void setIsPaused(boolean paused) {
        this.myIsPaused = paused;
        if (this.myIsPaused) {
            if (this.myClient != null) {
                this.stop();
            }
        } else {
            this.myTimelineData.clear();
            this.prepareSampler();
            this.start();
        }
    }

    public final boolean getIsPaused() {
        return this.myIsPaused;
    }

    @Nullable
    public Client getClient() {
        return this.myClient;
    }

    @NotNull
    public abstract String getName();

    public void addListener(TimelineEventListener listener) {
        this.myListeners.add(listener);
    }

    public boolean isRunning() {
        return this.myExecutingTask != null && this.myRunning;
    }

    protected boolean requiresSamplerRestart(@Nullable Client client) {
        return client != this.myClient;
    }

    protected synchronized void prepareSampler() {
    }

    protected void forceSample() {
        this.myDataSemaphore.release();
    }

    protected abstract void sample(boolean var1) throws InterruptedException;

    private synchronized void startSamplingTask() {
        Client client = this.myClient;
        if (this.myExecutingTask == null && client != null) {
            CountDownLatch taskFinished;
            this.myRunning = true;
            this.myTaskFinished = taskFinished = new CountDownLatch(1);
            this.myExecutingTask = ApplicationManager.getApplication().executeOnPooledThread(() -> {
                long timeToWait = this.mySampleFrequencyMs;
                try {
                    while (this.myRunning) {
                        long start = System.currentTimeMillis();
                        boolean acquired = this.myDataSemaphore.tryAcquire(timeToWait, TimeUnit.MILLISECONDS);
                        if (this.myRunning && !this.myIsPaused) {
                            this.sample(acquired);
                        }
                        if ((timeToWait -= System.currentTimeMillis() - start) <= 0L) {
                            timeToWait = this.mySampleFrequencyMs;
                        }
                        if (client.isValid()) continue;
                        ApplicationManager.getApplication().invokeLater(this::stop);
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.myRunning = false;
                    taskFinished.countDown();
                }
            });
            client.setHeapInfoUpdateEnabled(true);
            for (TimelineEventListener listener : this.myListeners) {
                listener.onStart();
            }
        }
    }

    private synchronized void stopSamplingTask() {
        Future<?> executingTask = this.myExecutingTask;
        Client client = this.myClient;
        if (executingTask == null) {
            return;
        }
        this.myRunning = false;
        this.myDataSemaphore.release();
        executingTask.cancel(true);
        CountDownLatch taskFinished = this.myTaskFinished;
        if (taskFinished != null) {
            try {
                taskFinished.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (client != null) {
            client.setHeapInfoUpdateEnabled(false);
        }
        for (TimelineEventListener listener : this.myListeners) {
            listener.onStop();
        }
        this.myTaskFinished = null;
        this.myExecutingTask = null;
    }
}

