/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.editor;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.adtui.ASGallery;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.naveditor.editor.NavActionManager;
import com.android.tools.idea.naveditor.surface.NavDesignSurface;
import com.google.common.collect.ImmutableList;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.JBCardLayout;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.IconUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListModel;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddMenuWrapper
extends DropDownAction {
    private static final JLabel RENDERER_COMPONENT = new JLabel();
    private static final String NEW_PANEL_NAME = "new";
    private static final String SELECTION_PANEL_NAME = "selection";
    private final NavDesignSurface mySurface;
    public final List<NavActionManager.Destination> myDestinations;
    public ComboBox<String> myKindPopup;
    JTextField myLabelField;
    JTextField myIdField;
    JLabel myClassLabel;
    ComboBox<String> myClassPopup;
    JLabel mySourceLabel;
    ComboBox<PsiFile> mySourcePopup;
    JLabel myValidationLabel;
    private final NavigationSchema mySchema;
    private JPanel myMainPanel;
    public JButton myNewDestinationButton;
    public JButton myBackButton;
    public JButton myCreateButton;
    public ASGallery<NavActionManager.Destination> myDestinationsGallery;
    private MediaTracker myMediaTracker;
    JBLoadingPanel myLoadingPanel;

    AddMenuWrapper(@NotNull NavDesignSurface surface, @NotNull List<NavActionManager.Destination> destinations) {
        super("", "Add Destination", IconUtil.getAddIcon());
        this.mySurface = surface;
        this.mySchema = this.mySurface.getSchema();
        this.myDestinations = destinations;
    }

    void addElement(@NotNull NavActionManager.Destination destination, @NotNull NavDesignSurface surface) {
        String tagName = destination.getTag();
        String qName = destination.getQualifiedName();
        Consumer<NlComponent> extraActions = component2 -> {
            XmlFile layout = destination.getLayoutFile();
            if (layout != null) {
                String layoutId = "@" + ResourceType.LAYOUT.getName() + "/" + FileUtil.getNameWithoutExtension((String)layout.getName());
                component2.setAttribute("http://schemas.android.com/tools", "layout", layoutId);
            }
        };
        this.addElement(surface, tagName, qName, qName, extraActions);
    }

    void addElement(final @NotNull NavDesignSurface surface, final @NotNull String tagName, final @NotNull String idBase, final @NotNull String name, final @Nullable Consumer<NlComponent> extraActions) {
        new WriteCommandAction(surface.getProject(), "Create " + name, new PsiFile[]{surface.getModel().getFile()}){

            protected void run(@NotNull Result result) throws Throwable {
                NlComponent parent = surface.getCurrentNavigation();
                XmlTag tag = parent.getTag().createChildTag(tagName, null, null, true);
                NlComponent newComponent = surface.getModel().createComponent(tag, parent, null);
                surface.getSelectionModel().setSelection((List<NlComponent>)ImmutableList.of((Object)newComponent));
                newComponent.assignId(idBase);
                newComponent.setAttribute("http://schemas.android.com/apk/res/android", "name", name);
                if (extraActions != null) {
                    extraActions.accept(newComponent);
                }
            }
        }.execute();
    }

    @Nullable
    protected JPanel createCustomComponentPopup() {
        this.myMainPanel = new JPanel((LayoutManager)new JBCardLayout());
        this.myMainPanel.add((Component)this.createSelectionPanel(), SELECTION_PANEL_NAME);
        this.myMainPanel.add((Component)this.createNewPanel(), NEW_PANEL_NAME);
        return this.myMainPanel;
    }

    @NotNull
    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    @NotNull
    private JPanel createNewPanel() {
        JPanel newPanel = new JPanel((LayoutManager)new VerticalLayout(10));
        JLabel destinationLabel = new JLabel("New Destination");
        newPanel.add(destinationLabel);
        newPanel.add(new JSeparator());
        JPanel selectionGrid = this.createAddControls();
        newPanel.add(selectionGrid);
        this.myValidationLabel = new JLabel("", AllIcons.General.Error, 2);
        this.myValidationLabel.setVisible(false);
        newPanel.add((Component)this.myValidationLabel, "BOTTOM");
        JPanel buttons = new JPanel((LayoutManager)new HorizontalLayout(2, 0));
        this.myBackButton = new JButton("Back");
        this.myBackButton.addActionListener(event -> ((JBCardLayout)this.myMainPanel.getLayout()).swipe((Container)this.myMainPanel, SELECTION_PANEL_NAME, JBCardLayout.SwipeDirection.BACKWARD));
        buttons.add(this.myBackButton);
        this.myCreateButton = new JButton("Create");
        this.myCreateButton.addActionListener(event -> {
            if (this.validate()) {
                this.createDestination();
            }
        });
        buttons.add(this.myCreateButton);
        JPanel bottomRow = new JPanel();
        bottomRow.add(buttons);
        newPanel.add((Component)bottomRow, "BOTTOM");
        newPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        return newPanel;
    }

    void createDestination() {
        if ("include".equals(this.myKindPopup.getSelectedItem())) {
            String filename = this.mySourcePopup.getSelectedItem() == null ? "dummy.xml" : ((PsiFile)this.mySourcePopup.getSelectedItem()).getName();
            this.addElement(this.mySurface, "include", this.myIdField.getText(), this.myLabelField.getText(), component2 -> component2.setAttribute("http://schemas.android.com/apk/res-auto", "graph", filename));
            return;
        }
        NavigationSchema.DestinationType type = this.mySchema.getDestinationType((String)this.myKindPopup.getSelectedItem());
        if (type == NavigationSchema.DestinationType.ACTIVITY || type == NavigationSchema.DestinationType.FRAGMENT) {
            String className = (String)this.myClassPopup.getSelectedItem();
            NavActionManager.Destination dest = new NavActionManager.Destination(null, className.substring(className.lastIndexOf(46) + 1), className, (String)this.myKindPopup.getSelectedItem(), null);
            this.addElement(dest, this.mySurface);
        } else if (type == NavigationSchema.DestinationType.NAVIGATION) {
            this.addElement(this.mySurface, (String)this.myKindPopup.getSelectedItem(), this.myIdField.getText(), this.myLabelField.getText(), null);
        }
        this.closePopup();
    }

    boolean validate() {
        String error = null;
        String kind = (String)this.myKindPopup.getSelectedItem();
        NavigationSchema.DestinationType type = this.mySchema.getDestinationType(kind);
        if (this.myLabelField.getText().isEmpty()) {
            error = "Label must be set";
        } else if (this.myIdField.getText().isEmpty()) {
            error = "ID must be set";
        } else if (this.myClassPopup.getSelectedItem() == null && (type == NavigationSchema.DestinationType.ACTIVITY || type == NavigationSchema.DestinationType.FRAGMENT)) {
            error = "Class must be set";
        }
        if (error != null) {
            this.myValidationLabel.setText(error);
            this.myValidationLabel.setVisible(true);
            return false;
        }
        this.myValidationLabel.setVisible(false);
        return true;
    }

    @NotNull
    private JPanel createAddControls() {
        TabularLayout layout = new TabularLayout("Fit,20px,*");
        layout.setVGap(3);
        JPanel selectionGrid = new JPanel((LayoutManager)layout);
        selectionGrid.add((Component)new JLabel("Kind"), new TabularLayout.Constraint(0, 0));
        selectionGrid.add((Component)new JLabel("Label"), new TabularLayout.Constraint(1, 0));
        this.myLabelField = new JTextField("Dest 0", 40);
        selectionGrid.add((Component)this.myLabelField, new TabularLayout.Constraint(1, 2));
        selectionGrid.add((Component)new JLabel("ID"), new TabularLayout.Constraint(2, 0));
        this.myIdField = new JTextField("dest_0", 40);
        selectionGrid.add((Component)this.myIdField, new TabularLayout.Constraint(2, 2));
        this.myClassLabel = new JLabel("Class");
        selectionGrid.add((Component)this.myClassLabel, new TabularLayout.Constraint(3, 0));
        this.createClassPopup();
        selectionGrid.add((Component)this.myClassPopup, new TabularLayout.Constraint(3, 2));
        this.mySourceLabel = new JLabel("Source");
        selectionGrid.add((Component)this.mySourceLabel, new TabularLayout.Constraint(3, 0));
        this.createSourcePopup();
        selectionGrid.add((Component)this.mySourcePopup, new TabularLayout.Constraint(3, 2));
        this.createKindPopup();
        selectionGrid.add((Component)this.myKindPopup, new TabularLayout.Constraint(0, 2));
        this.myKindPopup.setSelectedItem((Object)this.mySchema.getTag(NavigationSchema.DestinationType.FRAGMENT));
        return selectionGrid;
    }

    private void createClassPopup() {
        this.myClassPopup = new ComboBox();
        this.myClassPopup.setEditable(true);
    }

    private void createSourcePopup() {
        this.mySourcePopup = new ComboBox();
        this.mySourcePopup.addItem(null);
        LocalResourceManager resourceManager = LocalResourceManager.getInstance(this.mySurface.getModel().getModule());
        for (PsiFile navPsi : resourceManager.findResourceFiles(ResourceFolderType.NAVIGATION)) {
            if (this.mySurface.getModel().getFile().equals(navPsi)) continue;
            this.mySourcePopup.addItem((Object)navPsi);
        }
        this.mySourcePopup.setRenderer((list, value, index, isSelected, cellHasFocus) -> {
            if (value == null) {
                RENDERER_COMPONENT.setText("New...");
            } else {
                RENDERER_COMPONENT.setText(value.getName());
            }
            return RENDERER_COMPONENT;
        });
    }

    private void createKindPopup() {
        this.myKindPopup = new ComboBox();
        this.myKindPopup.setRenderer((list, value, index, isSelected, cellHasFocus) -> {
            NavigationSchema.DestinationType type = this.mySchema.getDestinationType((String)value);
            String text = type == NavigationSchema.DestinationType.NAVIGATION ? "Nested Graph" : (type == NavigationSchema.DestinationType.FRAGMENT ? "Fragment (default)" : (type == NavigationSchema.DestinationType.ACTIVITY ? "Activity" : ("include".equals(value) ? "Include Graph" : value)));
            RENDERER_COMPONENT.setText(text);
            return RENDERER_COMPONENT;
        });
        for (NavigationSchema.DestinationType type : NavigationSchema.DestinationType.values()) {
            for (String tag : this.mySchema.getDestinationClassByTagMap(type).keySet()) {
                if (tag == null) continue;
                this.myKindPopup.addItem((Object)tag);
            }
        }
        this.myKindPopup.addItem((Object)"include");
        this.myKindPopup.addItemListener(itemEvent -> {
            this.myClassLabel.setVisible(false);
            this.myClassPopup.setVisible(false);
            this.mySourceLabel.setVisible(false);
            this.mySourcePopup.setVisible(false);
            String item = (String)itemEvent.getItem();
            NavigationSchema.DestinationType type = this.mySchema.getDestinationType(item);
            if (type == NavigationSchema.DestinationType.ACTIVITY || type == NavigationSchema.DestinationType.FRAGMENT) {
                this.myClassLabel.setVisible(true);
                this.myClassPopup.setVisible(true);
            } else if ("include".equals(item)) {
                this.mySourceLabel.setVisible(true);
                this.mySourcePopup.setVisible(true);
            }
        });
    }

    @NotNull
    private JPanel createSelectionPanel() {
        CollectionListModel listModel = new CollectionListModel(this.myDestinations);
        this.myDestinationsGallery = new ASGallery<NavActionManager.Destination>((ListModel)listModel, d -> null, NavActionManager.Destination::getName, new Dimension(96, 96), null){

            @NotNull
            public Dimension getPreferredScrollableViewportSize() {
                Dimension cellSize = this.computeCellSize();
                int heightInsets = this.getInsets().top + this.getInsets().bottom;
                int widthInsets = this.getInsets().left + this.getInsets().right;
                return new Dimension(cellSize.width * 3 + widthInsets, (int)((double)cellSize.height * 2.2) + heightInsets);
            }

            public int locationToIndex(@NotNull Point location) {
                int index = super.locationToIndex(location);
                if (index != -1 && !this.getCellBounds(index, index).contains(location)) {
                    return -1;
                }
                return index;
            }
        };
        this.myDestinationsGallery.setBackground(null);
        this.myDestinationsGallery.addMouseMotionListener((MouseMotionListener)new MouseAdapter(){

            @Override
            public void mouseMoved(@NotNull MouseEvent event) {
                int index = AddMenuWrapper.this.myDestinationsGallery.locationToIndex(event.getPoint());
                if (index != -1) {
                    AddMenuWrapper.this.myDestinationsGallery.setSelectedIndex(index);
                    AddMenuWrapper.this.myDestinationsGallery.requestFocusInWindow();
                } else {
                    AddMenuWrapper.this.myDestinationsGallery.clearSelection();
                }
            }
        });
        JPanel selectionPanel = new JPanel((LayoutManager)new VerticalLayout(5));
        selectionPanel.add((Component)new SearchTextField());
        JBScrollPane scrollPane = new JBScrollPane(this.myDestinationsGallery);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.myMediaTracker = new MediaTracker((Component)this.myDestinationsGallery);
        this.myDestinations.forEach(destination -> this.myMediaTracker.addImage(destination.getThumbnail(), 0));
        if (!this.myMediaTracker.checkAll()) {
            this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this.mySurface);
            this.myLoadingPanel.add((Component)scrollPane, (Object)"Center");
            this.myLoadingPanel.startLoading();
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    this.myMediaTracker.waitForAll();
                    ApplicationManager.getApplication().invokeLater(() -> {
                        this.myDestinationsGallery.setImageProvider(NavActionManager.Destination::getThumbnail);
                        this.myLoadingPanel.stopLoading();
                    });
                }
                catch (Exception e) {
                    this.myLoadingPanel.setLoadingText("Failed to load thumbnails");
                }
            });
            selectionPanel.add((Component)this.myLoadingPanel);
        } else {
            this.myDestinationsGallery.setImageProvider(NavActionManager.Destination::getThumbnail);
            selectionPanel.add((Component)scrollPane);
        }
        this.myNewDestinationButton = new JButton("New Destination");
        JPanel createButtonPanel = new JPanel();
        createButtonPanel.add(this.myNewDestinationButton);
        selectionPanel.add(createButtonPanel);
        this.myNewDestinationButton.addActionListener(event -> ((JBCardLayout)this.myMainPanel.getLayout()).swipe((Container)this.myMainPanel, NEW_PANEL_NAME, JBCardLayout.SwipeDirection.FORWARD));
        this.myDestinationsGallery.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(@NotNull MouseEvent event) {
                if (AddMenuWrapper.this.myDestinationsGallery.getSelectedIndex() != -1) {
                    AddMenuWrapper.this.addElement((NavActionManager.Destination)AddMenuWrapper.this.myDestinationsGallery.getSelectedElement(), AddMenuWrapper.this.mySurface);
                    AddMenuWrapper.this.closePopup();
                }
            }
        });
        return selectionPanel;
    }

    protected boolean updateActions() {
        return true;
    }
}

