/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.property.inspector;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.inspector.InspectorComponent;
import com.android.tools.idea.uibuilder.property.inspector.InspectorPanel;
import com.android.tools.idea.uibuilder.property.inspector.InspectorProvider;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

public class ActionInspectorProvider
implements InspectorProvider {
    private InspectorComponent myComponent;
    private static final String[] ACTION_PROPERTIES = new String[]{"destination"};

    @Override
    public boolean isApplicable(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        if (components.size() == 1) {
            return components.get(0).getTagName().equals("action");
        }
        return false;
    }

    @Override
    @NotNull
    public InspectorComponent createCustomInspector(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        if (this.myComponent == null) {
            this.myComponent = new ActionInspectorComponent(properties, propertiesManager);
        }
        this.myComponent.updateProperties(components, properties, propertiesManager);
        return this.myComponent;
    }

    @Override
    public void resetCache() {
    }

    private static class ActionInspectorComponent
    implements InspectorComponent {
        private final List<NlComponentEditor> myEditors = new ArrayList<NlComponentEditor>();

        public ActionInspectorComponent(@NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
            this.createEditors(properties, propertiesManager);
        }

        private void createEditors(@NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
            for (String propertyName : ACTION_PROPERTIES) {
                boolean designPropertyRequired = propertyName.startsWith("tools:");
                NlProperty property = properties.get(propertyName = StringUtil.trimStart((String)propertyName, (String)"tools:"));
                if (property == null) continue;
                if (designPropertyRequired) {
                    property = property.getDesignTimeProperty();
                }
                NlComponentEditor editor = propertiesManager.getPropertyEditors().create(property);
                editor.setProperty(property);
                this.myEditors.add(editor);
            }
        }

        @Override
        public void updateProperties(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
            this.myEditors.clear();
            this.createEditors(properties, propertiesManager);
        }

        @Override
        @NotNull
        public List<NlComponentEditor> getEditors() {
            return this.myEditors;
        }

        @Override
        public int getMaxNumberOfRows() {
            return 1 + this.myEditors.size();
        }

        @Override
        public void attachToInspector(@NotNull InspectorPanel inspector) {
            this.refresh();
            inspector.addTitle("Action");
            for (NlComponentEditor editor : this.myEditors) {
                NlProperty property = editor.getProperty();
                String propertyName = property.getName();
                JLabel label = inspector.addComponent(propertyName, property.getTooltipText(), editor.getComponent());
                editor.setLabel(label);
            }
        }

        @Override
        public void refresh() {
            this.myEditors.forEach(NlComponentEditor::refresh);
        }
    }
}

