/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.property.inspector;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.inspector.InspectorComponent;
import com.android.tools.idea.uibuilder.property.inspector.InspectorPanel;
import com.android.tools.idea.uibuilder.property.inspector.InspectorProvider;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.annotations.NotNull;

public class NavigationInspectorProvider
implements InspectorProvider {
    private static final String[] NAVIGATION_PROPERTIES = new String[]{"name", "id", "label", "navType"};
    private final Map<String, InspectorComponent> myInspectors = new HashMap<String, InspectorComponent>();

    @Override
    public boolean isApplicable(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        if (components.size() != 1) {
            return false;
        }
        XmlTag tag = components.get(0).getTag();
        NavigationSchema schema = NavigationSchema.getOrCreateSchema(propertiesManager.getFacet());
        if (schema.getDestinationClassByTag(tag.getName()) == null) {
            return false;
        }
        String tagName = tag.getName();
        if (this.myInspectors.containsKey(tagName)) {
            return true;
        }
        this.myInspectors.put(tagName, new NavigationInspectorComponent(tagName, properties, propertiesManager));
        return true;
    }

    @Override
    @NotNull
    public InspectorComponent createCustomInspector(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
        String tagName = components.get(0).getTagName();
        InspectorComponent inspector = this.myInspectors.get(tagName);
        assert (inspector != null);
        inspector.updateProperties(components, properties, propertiesManager);
        return inspector;
    }

    @Override
    public void resetCache() {
        this.myInspectors.clear();
    }

    private static class NavigationInspectorComponent
    implements InspectorComponent {
        private final String myComponentName;
        private final List<NlComponentEditor> myEditors;

        public NavigationInspectorComponent(@NotNull String tagName, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
            this.myComponentName = tagName.substring(tagName.lastIndexOf(46) + 1);
            this.myEditors = new ArrayList<NlComponentEditor>(NAVIGATION_PROPERTIES.length);
            this.createEditors(properties, propertiesManager);
        }

        private void createEditors(@NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
            for (String propertyName : NAVIGATION_PROPERTIES) {
                NlProperty property = properties.get(propertyName);
                if (property == null) continue;
                NlComponentEditor editor = propertiesManager.getPropertyEditors().create(property);
                editor.setProperty(property);
                this.myEditors.add(editor);
            }
        }

        @Override
        public void updateProperties(@NotNull List<NlComponent> components, @NotNull Map<String, NlProperty> properties, @NotNull NlPropertiesManager propertiesManager) {
            this.myEditors.clear();
            this.createEditors(properties, propertiesManager);
        }

        @Override
        @NotNull
        public List<NlComponentEditor> getEditors() {
            return this.myEditors;
        }

        @Override
        public int getMaxNumberOfRows() {
            return 1 + this.myEditors.size();
        }

        @Override
        public void attachToInspector(@NotNull InspectorPanel inspector) {
            this.refresh();
            inspector.addTitle(this.myComponentName);
            for (NlComponentEditor editor : this.myEditors) {
                NlProperty property = editor.getProperty();
                String propertyName = property.getName();
                JLabel label = inspector.addComponent(propertyName, property.getTooltipText(), editor.getComponent());
                editor.setLabel(label);
            }
        }

        @Override
        public void refresh() {
            this.myEditors.forEach(NlComponentEditor::refresh);
        }
    }
}

