/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene;

import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.State;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.common.scene.decorator.SceneDecoratorFactory;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.naveditor.scene.decorator.NavSceneDecoratorFactory;
import com.android.tools.idea.naveditor.scene.layout.ManualLayoutAlgorithm;
import com.android.tools.idea.naveditor.scene.layout.NavSceneLayoutAlgorithm;
import com.android.tools.idea.naveditor.scene.targets.NavScreenTargetProvider;
import com.android.tools.idea.naveditor.surface.NavDesignSurface;
import com.android.tools.idea.rendering.TagSnapshot;
import com.android.util.PropertiesMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ui.UIUtil;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavSceneManager
extends SceneManager {
    private static final int SUBNAV_WIDTH = 100;
    private static final int SUBNAV_HEIGHT = 25;
    private final NavScreenTargetProvider myScreenTargetProvider;
    private NavSceneLayoutAlgorithm myLayoutAlgorithm;
    private SceneDecoratorFactory myDecoratorFactory;
    private static final String ENABLE_NAV_PROPERTY = "enable.nav.editor";

    public NavSceneManager(@NotNull NlModel model, @NotNull NavDesignSurface surface) {
        super(model, surface);
        NavigationSchema schema = surface.getSchema();
        this.myLayoutAlgorithm = new ManualLayoutAlgorithm(model.getModule());
        surface.zoomActual();
        this.myScreenTargetProvider = new NavScreenTargetProvider(this.myLayoutAlgorithm, schema);
    }

    public static boolean enableNavigationEditor() {
        return Boolean.getBoolean(ENABLE_NAV_PROPERTY);
    }

    @Override
    @NotNull
    public Scene build() {
        NavSceneManager.updateHierarchy(this.getModel(), null);
        Scene scene = super.build();
        this.getModel().addListener(new ModelChangeListener());
        this.getDesignSurface().getSelectionModel().addListener((model, selection) -> scene.needsRebuildList());
        this.requestRender();
        return scene;
    }

    @Override
    @NotNull
    public NavDesignSurface getDesignSurface() {
        return (NavDesignSurface)super.getDesignSurface();
    }

    @Override
    protected void updateFromComponent(@NotNull SceneComponent sceneComponent) {
        super.updateFromComponent(sceneComponent);
        NavigationSchema.DestinationType type = this.getDesignSurface().getSchema().getDestinationType(sceneComponent.getNlComponent().getTagName());
        if (type != null) {
            sceneComponent.setTargetProvider(this.myScreenTargetProvider, false);
            switch (type) {
                case NAVIGATION: {
                    if (sceneComponent.getNlComponent() == this.getDesignSurface().getCurrentNavigation()) {
                        sceneComponent.setSize(-1, -1, false);
                        break;
                    }
                    sceneComponent.setSize(100, 25, false);
                    break;
                }
                case FRAGMENT: 
                case ACTIVITY: {
                    State state = this.getModel().getConfiguration().getDeviceState();
                    assert (state != null);
                    Screen screen = state.getHardware().getScreen();
                    sceneComponent.setSize(screen.getXDimension() / 4, screen.getYDimension() / 4, true);
                    break;
                }
            }
        }
    }

    @Override
    protected void postUpdateFromComponent(@NotNull SceneComponent sceneComponent) {
        NavigationSchema.DestinationType type = this.getDesignSurface().getSchema().getDestinationType(sceneComponent.getNlComponent().getTagName());
        if (type == NavigationSchema.DestinationType.NAVIGATION && sceneComponent.getNlComponent() == this.getDesignSurface().getCurrentNavigation()) {
            this.layoutAll(sceneComponent);
            this.updateRootBounds(sceneComponent);
        }
    }

    private void updateRootBounds(@NotNull SceneComponent root) {
        Rectangle bounds = new Rectangle(0, 0, -1, -1);
        Rectangle temp = new Rectangle();
        Rectangle rootBounds = root.fillRect(null);
        root.flatten().filter(c -> c != root).forEach(component2 -> {
            if (component2.isDragging()) {
                if (bounds.width < 0) {
                    bounds.setBounds(rootBounds);
                } else {
                    bounds.add(rootBounds);
                }
                bounds.add(component2.getCenterX(), component2.getCenterY());
            } else {
                Rectangle componentBounds = component2.fillDrawRect(0L, temp);
                componentBounds.setLocation(componentBounds.x - 50, componentBounds.y - 50);
                componentBounds.setSize(componentBounds.width + 100, componentBounds.height + 100);
                if (bounds.width < 0) {
                    bounds.setBounds(componentBounds);
                } else {
                    bounds.add(componentBounds);
                }
            }
        });
        NavDesignSurface surface = this.getDesignSurface();
        SceneView view = surface.getCurrentSceneView();
        if (view != null) {
            surface.getCurrentSceneView().setLocation(Math.max(0, Coordinates.getSwingXDip(view, bounds.x)), Math.max(0, Coordinates.getSwingYDip(view, bounds.y)));
        }
        root.setPosition(bounds.x, bounds.y);
        root.setSize(bounds.width, bounds.height, false);
    }

    @Override
    @NotNull
    protected NlComponent getRoot() {
        return this.getDesignSurface().getCurrentNavigation();
    }

    @Override
    @Nullable
    protected SceneComponent createHierarchy(@NotNull NlComponent component2) {
        NavigationSchema.DestinationType type = this.getDesignSurface().getSchema().getDestinationType(component2.getTagName());
        if (type != null) {
            switch (type) {
                case NAVIGATION: {
                    if (component2 != this.getRoot()) {
                        SceneComponent sceneComponent = this.getScene().getSceneComponent(component2);
                        if (sceneComponent == null) {
                            sceneComponent = new SceneComponent(this.getScene(), component2);
                        }
                        return sceneComponent;
                    }
                    return super.createHierarchy(component2);
                }
                case FRAGMENT: 
                case ACTIVITY: {
                    return super.createHierarchy(component2);
                }
            }
        }
        return null;
    }

    @Override
    @NotNull
    public TemporarySceneComponent createTemporaryComponent(@NotNull NlComponent component2) {
        return new TemporarySceneComponent(this.getScene(), component2);
    }

    @Override
    public void requestRender() {
        this.update();
        SceneComponent root = this.getScene().getRoot();
        if (root != null) {
            root.updateTargets(true);
            this.layoutAll(root);
        }
    }

    private void layoutAll(@NotNull SceneComponent root) {
        root.flatten().filter(component2 -> component2.getParent() != null).forEach(component2 -> component2.setPosition(0, 0));
        root.flatten().filter(component2 -> component2.getParent() != null).forEach(this.myLayoutAlgorithm::layout);
    }

    @Override
    public void layout(boolean animate) {
        SceneComponent root = this.getScene().getRoot();
        if (root != null) {
            this.updateRootBounds(root);
        }
        this.getDesignSurface().updateScrolledAreaSize();
        this.getScene().needsRebuildList();
    }

    @Override
    @NotNull
    public SceneDecoratorFactory getSceneDecoratorFactory() {
        if (this.myDecoratorFactory == null) {
            this.myDecoratorFactory = new NavSceneDecoratorFactory(this.getDesignSurface().getSchema());
        }
        return this.myDecoratorFactory;
    }

    @Override
    public Map<Object, PropertiesMap> getDefaultProperties() {
        return ImmutableMap.of();
    }

    public static void updateHierarchy(@NotNull NlModel model, @Nullable NlModel newModel) {
        Object roots = ImmutableList.of();
        XmlTag newRoot = AndroidPsiUtils.getRootTagSafely(model.getFile());
        if (newModel != null) {
            newRoot = AndroidPsiUtils.getRootTagSafely(newModel.getFile());
            roots = NavSceneManager.buildTree((XmlTag[])newModel.getComponents().stream().map(NlComponent::getTag).toArray(XmlTag[]::new));
        }
        if (newRoot != null) {
            model.syncWithPsi(newRoot, (List<NlModel.TagSnapshotTreeNode>)roots);
        }
    }

    private static List<NlModel.TagSnapshotTreeNode> buildTree(XmlTag[] roots) {
        ArrayList<NlModel.TagSnapshotTreeNode> result = new ArrayList<NlModel.TagSnapshotTreeNode>();
        for (final XmlTag root : roots) {
            NlModel.TagSnapshotTreeNode node = new NlModel.TagSnapshotTreeNode(){

                @Override
                public TagSnapshot getTagSnapshot() {
                    return TagSnapshot.createTagSnapshot(root, null);
                }

                @Override
                @NotNull
                public List<NlModel.TagSnapshotTreeNode> getChildren() {
                    return NavSceneManager.buildTree(root.getSubTags());
                }
            };
            result.add(node);
        }
        return result;
    }

    private class ModelChangeListener
    implements ModelListener {
        private ModelChangeListener() {
        }

        @Override
        public void modelDerivedDataChanged(@NotNull NlModel model) {
        }

        @Override
        public void modelChanged(@NotNull NlModel model) {
            NavSceneManager.updateHierarchy(model, model);
            NavSceneManager.this.requestRender();
        }

        @Override
        public void modelRendered(@NotNull NlModel model) {
            UIUtil.invokeLaterIfNeeded(NavSceneManager.this::update);
        }

        @Override
        public void modelChangedOnLayout(@NotNull NlModel model, boolean animate) {
            boolean previous = NavSceneManager.this.getScene().isAnimated();
            UIUtil.invokeLaterIfNeeded(() -> {
                NavSceneManager.this.getScene().setAnimated(animate);
                NavSceneManager.this.update();
                NavSceneManager.this.getScene().setAnimated(previous);
            });
        }

        @Override
        public void modelActivated(@NotNull NlModel model) {
            NavSceneManager.updateHierarchy(model, model);
        }

        @Override
        public void modelDeactivated(@NotNull NlModel model) {
        }
    }
}

