/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene;

import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.ImagePool;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.res.AppResourceRepository;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetScopedService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class ThumbnailManager
extends AndroidFacetScopedService {
    private static final Key<ThumbnailManager> KEY = Key.create((String)ThumbnailManager.class.getName());
    private final Table<XmlFile, Configuration, ImagePool.Image> myImages = HashBasedTable.create();
    private final Table<XmlFile, Configuration, Long> myRenderVersions = HashBasedTable.create();
    private final Table<XmlFile, Configuration, Long> myRenderModStamps = HashBasedTable.create();
    private final AppResourceRepository myResourceRepository;

    @NotNull
    public static ThumbnailManager getInstance(@NotNull AndroidFacet facet) {
        ThumbnailManager manager = (ThumbnailManager)facet.getUserData(KEY);
        if (manager == null) {
            manager = new ThumbnailManager(facet);
            ThumbnailManager.setInstance(facet, manager);
        }
        return manager;
    }

    public static void setInstance(@NotNull AndroidFacet facet, @Nullable ThumbnailManager manager) {
        facet.putUserData(KEY, manager);
    }

    protected ThumbnailManager(@NotNull AndroidFacet facet) {
        super(facet);
        this.myResourceRepository = AppResourceRepository.getOrCreateInstance(facet);
    }

    @Nullable
    public CompletableFuture<ImagePool.Image> getThumbnail(@NotNull XmlFile file, @NotNull DesignSurface surface, @NotNull Configuration configuration) {
        ImagePool.Image cached = (ImagePool.Image)this.myImages.get((Object)file, (Object)configuration);
        long version = this.myResourceRepository.getModificationCount();
        long modStamp = file.getModificationStamp();
        if (cached != null && (Long)this.myRenderVersions.get((Object)file, (Object)configuration) == version && ((Long)this.myRenderModStamps.get((Object)file, (Object)configuration)).longValue() == file.getModificationStamp()) {
            return CompletableFuture.completedFuture(cached);
        }
        RenderService renderService = RenderService.getInstance(this.getFacet());
        RenderLogger logger = renderService.createLogger();
        RenderTask task = this.createTask(file, surface, configuration, renderService, logger);
        CompletableFuture<ImagePool.Image> result = new CompletableFuture<ImagePool.Image>();
        if (task != null) {
            ListenableFuture<RenderResult> renderResult = task.render();
            renderResult.addListener(() -> {
                try {
                    ImagePool.Image image = ((RenderResult)renderResult.get()).getRenderedImage();
                    this.myImages.put((Object)file, (Object)configuration, (Object)image);
                    this.myRenderVersions.put((Object)file, (Object)configuration, (Object)version);
                    this.myRenderModStamps.put((Object)file, (Object)configuration, (Object)modStamp);
                    result.complete(image);
                }
                catch (InterruptedException | ExecutionException e) {
                    result.completeExceptionally(e);
                }
            }, (Executor)PooledThreadExecutor.INSTANCE);
        } else {
            result.complete(null);
        }
        return result;
    }

    @Nullable
    protected RenderTask createTask(@NotNull XmlFile file, @NotNull DesignSurface surface, @NotNull Configuration configuration, RenderService renderService, RenderLogger logger) {
        RenderTask task = renderService.createTask((PsiFile)file, configuration, logger, surface);
        if (task != null) {
            task.setDecorations(false);
        }
        return task;
    }

    @Override
    protected void onServiceDisposal(@NotNull AndroidFacet facet) {
    }
}

