/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.decorator;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.decorator.SceneDecorator;
import com.android.tools.idea.common.scene.decorator.SceneDecoratorFactory;
import com.android.tools.idea.naveditor.scene.decorator.NavScreenDecorator;
import com.android.tools.idea.naveditor.scene.decorator.NavigationDecorator;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.annotations.NotNull;

public class NavSceneDecoratorFactory
extends SceneDecoratorFactory {
    private static final Map<String, Constructor<? extends SceneDecorator>> ourConstructorMap = new HashMap<String, Constructor<? extends SceneDecorator>>();

    public NavSceneDecoratorFactory(@NotNull NavigationSchema schema) {
        for (NavigationSchema.DestinationType type : NavigationSchema.DestinationType.values()) {
            for (String tag : schema.getDestinationClassByTagMap(type).keySet()) {
                try {
                    Constructor constructor = type == NavigationSchema.DestinationType.NAVIGATION ? NavigationDecorator.class.getConstructor(new Class[0]) : NavScreenDecorator.class.getConstructor(new Class[0]);
                    ourConstructorMap.put(tag, constructor);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
        }
    }

    @Override
    @NotNull
    public SceneDecorator get(@NotNull NlComponent component2) {
        return this.get(component2.getTagName()).orElse(BASIC_DECORATOR);
    }

    @Override
    @NotNull
    protected Map<String, Constructor<? extends SceneDecorator>> getConstructorMap() {
        return ourConstructorMap;
    }
}

