/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.decorator;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.decorator.SceneDecorator;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.naveditor.scene.ThumbnailManager;
import com.android.tools.idea.naveditor.scene.decorator.NavigationDecorator;
import com.android.tools.idea.naveditor.scene.draw.DrawNavScreen;
import com.android.tools.idea.rendering.ImagePool;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class NavScreenDecorator
extends SceneDecorator {
    @Override
    protected void addContent(@NotNull DisplayList list, long time2, @NotNull SceneContext sceneContext, @NotNull SceneComponent component2) {
        ImagePool.Image image;
        super.addContent(list, time2, sceneContext, component2);
        DesignSurface surface = sceneContext.getSurface();
        if (surface == null) {
            return;
        }
        Configuration configuration = surface.getConfiguration();
        AndroidFacet facet = surface.getModel().getFacet();
        String layout = component2.getNlComponent().getAttribute("http://schemas.android.com/tools", "layout");
        if (layout == null) {
            return;
        }
        ResourceValue value = configuration.getResourceResolver().findResValue(layout, false);
        if (value == null) {
            return;
        }
        String fileName = value.getValue();
        if (fileName == null) {
            return;
        }
        File file = new File(fileName);
        if (!file.exists()) {
            return;
        }
        ThumbnailManager manager = ThumbnailManager.getInstance(facet);
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)false);
        if (virtualFile == null) {
            return;
        }
        PsiFile psiFile = AndroidPsiUtils.getPsiFileSafely(surface.getProject(), virtualFile);
        if (!(psiFile instanceof XmlFile)) {
            return;
        }
        CompletableFuture<ImagePool.Image> thumbnail = manager.getThumbnail((XmlFile)psiFile, surface, configuration);
        if (thumbnail == null) {
            return;
        }
        try {
            image = thumbnail.get();
        }
        catch (InterruptedException | ExecutionException ignore) {
            return;
        }
        list.add(new DrawNavScreen(sceneContext.getSwingX(component2.getDrawX()) + 1, sceneContext.getSwingY(component2.getDrawY()) + 1, sceneContext.getSwingDimension(component2.getDrawWidth()) - 1, sceneContext.getSwingDimension(component2.getDrawHeight()) - 1, image));
    }

    @Override
    public void buildList(@NotNull DisplayList list, long time2, @NotNull SceneContext sceneContext, @NotNull SceneComponent component2) {
        DisplayList displayList = new DisplayList();
        super.buildList(displayList, time2, sceneContext, component2);
        list.add(NavigationDecorator.createDrawCommand(displayList, component2));
    }
}

