/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.naveditor.scene.draw.NavBaseDrawCommand;
import com.android.tools.idea.naveditor.scene.targets.ActionTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawConnectionUtils;
import com.android.tools.sherpa.drawing.ColorSet;
import com.google.common.collect.ImmutableMap;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DrawAction
extends NavBaseDrawCommand {
    private static final Map<RenderingHints.Key, Object> HQ_RENDERING_HITS = ImmutableMap.of((Object)RenderingHints.KEY_ANTIALIASING, (Object)RenderingHints.VALUE_ANTIALIAS_ON, (Object)RenderingHints.KEY_RENDERING, (Object)RenderingHints.VALUE_RENDER_QUALITY, (Object)RenderingHints.KEY_INTERPOLATION, (Object)RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    private static final GeneralPath PATH = new GeneralPath();
    private final ActionTarget.ConnectionType myConnectionType;
    private Rectangle mySource = new Rectangle();
    private Rectangle myDest = new Rectangle();
    private static final Stroke BACKGROUND_STROKE = new BasicStroke(8.0f);
    private final DrawMode myMode;

    @Override
    @NotNull
    protected Object[] getProperties() {
        return new Object[]{this.myConnectionType, DrawAction.rectToString(this.mySource), DrawAction.rectToString(this.myDest), this.myMode};
    }

    private static String rectToString(@NotNull Rectangle r) {
        return r.x + "x" + r.y + "x" + r.width + "x" + r.height;
    }

    private static Rectangle stringToRect(@NotNull String s) {
        String[] sp = s.split("x");
        int c = 0;
        Rectangle r = new Rectangle();
        r.x = Integer.parseInt(sp[c++]);
        r.y = Integer.parseInt(sp[c++]);
        r.width = Integer.parseInt(sp[c++]);
        r.height = Integer.parseInt(sp[c++]);
        return r;
    }

    public DrawAction(@NotNull String s) {
        String[] sp = s.split(",");
        int c = 0;
        this.myConnectionType = ActionTarget.ConnectionType.valueOf(sp[c++]);
        this.mySource = DrawAction.stringToRect(sp[c++]);
        this.myDest = DrawAction.stringToRect(sp[c++]);
        this.myMode = DrawMode.valueOf(sp[c++]);
    }

    @Override
    public int getLevel() {
        return 21;
    }

    @Override
    public void paint(@NotNull Graphics2D g, @NotNull SceneContext sceneContext) {
        g.setRenderingHints(HQ_RENDERING_HITS);
        Color previousColor = g.getColor();
        ColorSet color = sceneContext.getColorSet();
        g.setColor(color.getConstraints());
        DrawAction.draw(g, color, this.myConnectionType, this.mySource, this.myDest, this.myMode);
        g.setColor(previousColor);
    }

    private DrawAction(@NotNull ActionTarget.ConnectionType connectionType, Rectangle source, Rectangle dest, @NotNull DrawMode mode) {
        this.mySource.setBounds(source);
        this.myDest.setBounds(dest);
        this.myConnectionType = connectionType;
        this.mySource.setBounds(source);
        this.myDest.setBounds(dest);
        this.myMode = mode;
    }

    public static void buildDisplayList(@NotNull DisplayList list, @NotNull ActionTarget.ConnectionType connectionType, Rectangle source, Rectangle dest, @NotNull DrawMode mode) {
        list.add(new DrawAction(connectionType, source, dest, mode));
    }

    private static void draw(@NotNull Graphics2D g, @NotNull ColorSet color, @NotNull ActionTarget.ConnectionType connectionType, Rectangle source, Rectangle dest, @NotNull DrawMode mode) {
        Color actionColor = mode == DrawMode.SELECTED ? color.getSelectedFrames() : color.getFrames();
        ActionTarget.CurvePoints points = ActionTarget.getCurvePoints(source, dest);
        PATH.reset();
        PATH.moveTo(points.p1.x, points.p1.y);
        switch (connectionType) {
            case SELF: {
                break;
            }
            case NORMAL: {
                g.setColor(actionColor);
                PATH.curveTo(points.p2.x, points.p2.y, points.p3.x, points.p3.y, points.p4.x, points.p4.y);
                Stroke defaultStroke = g.getStroke();
                g.setStroke(BACKGROUND_STROKE);
                g.setColor(color.getBackground());
                int[] xPoints = new int[3];
                int[] yPoints = new int[3];
                int arrowX = points.p4.x - ActionTarget.getDestinationDx(points.dir);
                int arrowY = points.p4.y - ActionTarget.getDestinationDy(points.dir);
                DrawConnectionUtils.getArrow(points.dir.ordinal(), arrowX, arrowY, xPoints, yPoints);
                g.fillPolygon(xPoints, yPoints, 3);
                g.draw(PATH);
                g.setStroke(defaultStroke);
                g.setColor(actionColor);
                DrawConnectionUtils.getArrow(points.dir.ordinal(), arrowX, arrowY, xPoints, yPoints);
                g.fillPolygon(xPoints, yPoints, 3);
                g.draw(PATH);
            }
        }
    }

    public static enum DrawMode {
        NORMAL,
        SELECTED;

    }
}

