/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.naveditor.scene.draw.NavBaseDrawCommand;
import java.awt.Color;
import java.awt.Graphics2D;
import org.jetbrains.annotations.NotNull;

public class DrawActionHandle
extends NavBaseDrawCommand {
    public static final int BACKGROUND_RADIUS = 6;
    public static final int SMALL_RADIUS = 8;
    public static final int LARGE_RADIUS = 12;
    public static final int BORDER_THICKNESS = 3;
    public static final int MAX_DURATION = 200;
    private final int myX;
    private final int myY;
    private final int myInitialRadius;
    private final int myFinalRadius;
    private final Color myBorderColor;
    private final Color myFillColor;
    private long myStartTime = -1L;

    public DrawActionHandle(int x, int y, int initialRadius, int finalRadius, @NotNull Color borderColor, @NotNull Color fillColor) {
        this.myX = x;
        this.myY = y;
        this.myInitialRadius = initialRadius;
        this.myFinalRadius = finalRadius;
        this.myBorderColor = borderColor;
        this.myFillColor = fillColor;
    }

    @Override
    public int getLevel() {
        return 24;
    }

    @Override
    @NotNull
    protected Object[] getProperties() {
        return new Object[]{this.myX, this.myY, this.myInitialRadius, this.myFinalRadius, String.format("%x", this.myBorderColor.getRGB()), String.format("%x", this.myFillColor.getRGB())};
    }

    @Override
    public void paint(@NotNull Graphics2D g, @NotNull SceneContext sceneContext) {
        long currentTime = sceneContext.getTime();
        if (this.myStartTime == -1L) {
            this.myStartTime = currentTime;
        }
        int delta = this.myFinalRadius - this.myInitialRadius;
        int duration = Math.abs(delta) * 200 / 12;
        int elapsed = (int)(currentTime - this.myStartTime);
        int r = this.myFinalRadius;
        if (elapsed < duration) {
            r = this.myInitialRadius + delta * elapsed / duration;
        }
        DrawActionHandle.fillCircle(g, this.myX, this.myY, Math.max(r, 6), this.myBorderColor);
        DrawActionHandle.fillCircle(g, this.myX, this.myY, r - 3, this.myFillColor);
        if (r != this.myFinalRadius) {
            sceneContext.repaint();
        }
    }

    private static void fillCircle(Graphics2D g, int x, int y, int r, Color color) {
        g.setColor(color);
        g.fillOval(x - r, y - r, 2 * r, 2 * r);
    }
}

