/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.naveditor.scene.draw.NavBaseDrawCommand;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import org.jetbrains.annotations.NotNull;

public class DrawActionHandleDrag
extends NavBaseDrawCommand {
    public static final Stroke STROKE = new BasicStroke(3.0f);
    private final int myX;
    private final int myY;
    private final Color myColor;

    public DrawActionHandleDrag(int x, int y, @NotNull Color color) {
        this.myX = x;
        this.myY = y;
        this.myColor = color;
    }

    @Override
    public int getLevel() {
        return 25;
    }

    @Override
    @NotNull
    protected Object[] getProperties() {
        return new Object[]{this.myX, this.myY, String.format("%x", this.myColor.getRGB())};
    }

    @Override
    public void paint(@NotNull Graphics2D g, @NotNull SceneContext sceneContext) {
        Color previousColor = g.getColor();
        g.setColor(this.myColor);
        g.fillOval(this.myX - 8, this.myY - 8, 16, 16);
        Stroke previousStroke = g.getStroke();
        g.setStroke(STROKE);
        g.drawLine(this.myX, this.myY, sceneContext.getMouseX(), sceneContext.getMouseY());
        g.setColor(previousColor);
        g.setStroke(previousStroke);
    }
}

