/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.naveditor.scene.draw.NavBaseDrawCommand;
import com.android.tools.idea.rendering.ImagePool;
import com.google.common.collect.ImmutableMap;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DrawNavScreen
extends NavBaseDrawCommand {
    private static final Map<RenderingHints.Key, Object> HQ_RENDERING_HITS = ImmutableMap.of((Object)RenderingHints.KEY_ANTIALIASING, (Object)RenderingHints.VALUE_ANTIALIAS_ON, (Object)RenderingHints.KEY_RENDERING, (Object)RenderingHints.VALUE_RENDER_QUALITY, (Object)RenderingHints.KEY_INTERPOLATION, (Object)RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    private final int myX;
    private final int myY;
    private final int myWidth;
    private final int myHeight;
    @NotNull
    private final ImagePool.Image myImage;

    public DrawNavScreen(int x, int y, int width, int height, @NotNull ImagePool.Image image) {
        this.myX = x;
        this.myY = y;
        this.myWidth = width;
        this.myHeight = height;
        this.myImage = image;
    }

    @Override
    public int getLevel() {
        return 23;
    }

    @Override
    public void paint(@NotNull Graphics2D g, @NotNull SceneContext sceneContext) {
        g.setRenderingHints(HQ_RENDERING_HITS);
        Shape previousClip = g.getClip();
        g.clipRect(this.myX, this.myY, this.myWidth, this.myHeight);
        this.myImage.drawImageTo(g, this.myX, this.myY, this.myWidth, this.myHeight);
        g.setClip(previousClip);
    }

    @Override
    @NotNull
    protected Object[] getProperties() {
        return new Object[]{this.myX, this.myY, this.myWidth, this.myHeight};
    }
}

