/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.naveditor.scene.draw.NavBaseDrawCommand;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import org.jetbrains.annotations.NotNull;

public class DrawScreenLabel
extends NavBaseDrawCommand {
    private final int myX;
    private final int myY;
    private final Color myColor;
    private final Font myFont;
    private final String myText;

    public DrawScreenLabel(int x, int y, @NotNull Color color, @NotNull Font font, @NotNull String text) {
        this.myX = x;
        this.myY = y;
        this.myColor = color;
        this.myFont = font;
        this.myText = text;
    }

    @Override
    public int getLevel() {
        return 22;
    }

    @Override
    @NotNull
    protected Object[] getProperties() {
        return new Object[]{this.myX, this.myY, String.format("%x", this.myColor.getRGB()), this.myFont, this.myText};
    }

    @Override
    public void paint(@NotNull Graphics2D g, @NotNull SceneContext sceneContext) {
        Color previousColor = g.getColor();
        Font previousFont = g.getFont();
        g.setColor(this.myColor);
        g.setFont(this.myFont);
        g.drawString(this.myText, this.myX, this.myY);
        g.setColor(previousColor);
        g.setFont(previousFont);
    }
}

