/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.layout;

import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.naveditor.scene.layout.NavSceneLayoutAlgorithm;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.annotations.NotNull;

public class DummyAlgorithm
implements NavSceneLayoutAlgorithm {
    private static final int WIDTH = 1000;
    private final NavigationSchema mySchema;

    public DummyAlgorithm(NavigationSchema schema) {
        this.mySchema = schema;
    }

    @Override
    public void layout(@NotNull SceneComponent component2) {
        NavigationSchema.DestinationType type = this.mySchema.getDestinationType(component2.getNlComponent().getTagName());
        if (type == NavigationSchema.DestinationType.NAVIGATION && component2.getParent() == null) {
            return;
        }
        SceneComponent root = component2.getScene().getRoot();
        HashMap<SceneComponent, Rectangle> bounds = root == null ? new HashMap<SceneComponent, Rectangle>() : root.flatten().filter(c -> c.getParent() != null).collect(Collectors.toMap(c -> c, c -> c.fillDrawRect(0L, null)));
        int xOffset = 50;
        int yOffset = 50;
        do {
            component2.setPosition(xOffset, yOffset);
            Rectangle newBounds = component2.fillDrawRect(0L, null);
            bounds.put(component2, newBounds);
            if ((xOffset += 130) + component2.getDrawWidth() <= 1000) continue;
            yOffset += 130;
            xOffset = 50;
        } while (!DummyAlgorithm.checkOverlaps(bounds, component2));
    }

    private static boolean checkOverlaps(@NotNull Map<SceneComponent, Rectangle> bounds, @NotNull SceneComponent component2) {
        Rectangle componentBounds = component2.fillDrawRect(0L, null);
        for (Map.Entry<SceneComponent, Rectangle> existing : bounds.entrySet()) {
            if (!componentBounds.intersects(existing.getValue()) || existing.getKey() == component2) continue;
            return false;
        }
        return true;
    }
}

