/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.layout;

import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.naveditor.scene.layout.DummyAlgorithm;
import com.android.tools.idea.naveditor.scene.layout.NavSceneLayoutAlgorithm;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.module.Module;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class ManualLayoutAlgorithm
implements NavSceneLayoutAlgorithm {
    private NavSceneLayoutAlgorithm myFallback;
    private NavigationSchema mySchema;
    private Module myModule;
    private Storage myStorage;

    public ManualLayoutAlgorithm(@NotNull Module module) {
        this.myModule = module;
    }

    ManualLayoutAlgorithm(@NotNull NavSceneLayoutAlgorithm fallback, @NotNull NavigationSchema schema, @NotNull LayoutPositions state) {
        this.myFallback = fallback;
        this.mySchema = schema;
        this.myStorage = new Storage();
        this.myStorage.myState = state;
    }

    @NotNull
    private NavigationSchema getSchema() {
        if (this.mySchema == null) {
            AndroidFacet instance = AndroidFacet.getInstance(this.myModule);
            assert (instance != null);
            this.mySchema = NavigationSchema.getOrCreateSchema(instance);
        }
        return this.mySchema;
    }

    private NavSceneLayoutAlgorithm getFallback() {
        if (this.myFallback == null) {
            this.myFallback = new DummyAlgorithm(this.getSchema());
        }
        return this.myFallback;
    }

    @Override
    public void layout(@NotNull SceneComponent component2) {
        NavigationSchema.DestinationType type = this.getSchema().getDestinationType(component2.getNlComponent().getTagName());
        if (type == NavigationSchema.DestinationType.NAVIGATION && component2.getParent() == null) {
            return;
        }
        Point location = this.getStorage().getState().getPositions().get(component2.getId());
        if (location != null) {
            component2.setPosition(location.x, location.y);
        } else {
            this.getFallback().layout(component2);
        }
    }

    public void save(@NotNull SceneComponent component2) {
        this.getStorage().getState().getPositions().put(component2.getId(), new Point(component2.getDrawX(), component2.getDrawY()));
    }

    @NotNull
    private Storage getStorage() {
        if (this.myStorage == null) {
            this.myStorage = (Storage)this.myModule.getProject().getComponent(Storage.class);
        }
        return this.myStorage;
    }

    @State(name="navEditor-manualLayoutAlgorithm", storages={@com.intellij.openapi.components.Storage(file="navEditor.xml")})
    private static class Storage
    implements PersistentStateComponent<LayoutPositions> {
        private LayoutPositions myState;

        private Storage() {
        }

        @NotNull
        public LayoutPositions getState() {
            if (this.myState == null) {
                this.myState = new LayoutPositions();
            }
            return this.myState;
        }

        public void loadState(@NotNull LayoutPositions state) {
            this.myState = state;
        }
    }

    static class LayoutPositions {
        public Map<String, Point> myPositions = new HashMap<String, Point>();

        LayoutPositions() {
        }

        public Map<String, Point> getPositions() {
            return this.myPositions;
        }
    }

    static class Point {
        public int x;
        public int y;

        public Point() {
        }

        public Point(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

