/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.targets;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.ScenePicker;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawCommand;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.naveditor.scene.draw.DrawActionHandle;
import com.android.tools.idea.naveditor.scene.draw.DrawActionHandleDrag;
import com.android.tools.idea.naveditor.scene.targets.NavBaseTarget;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import java.awt.Color;
import java.awt.Cursor;
import java.util.List;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionHandleTarget
extends NavBaseTarget {
    private int myCurrentRadius = 0;
    private boolean myIsDragging = false;

    public ActionHandleTarget(@NotNull SceneComponent component2) {
        super(component2);
    }

    @Override
    public int getPreferenceLevel() {
        return 70;
    }

    @Override
    public boolean layout(@NotNull SceneContext sceneTransform, int l, int t, int r, int b) {
        this.layoutCircle(r, t + (b - t) / 2, 12);
        return false;
    }

    @Override
    public void mouseDown(int x, int y) {
        this.myIsDragging = true;
        this.myComponent.getScene().needsRebuildList();
        this.getComponent().setDragging(true);
    }

    @Override
    public void mouseRelease(int x, int y, @Nullable List<Target> closestTargets) {
        this.myIsDragging = false;
        this.getComponent().setDragging(false);
    }

    public void createAction(@NotNull SceneComponent destination) {
        final NlComponent destinationNlComponent = destination.getNlComponent();
        NavigationSchema schema = NavigationSchema.getOrCreateSchema(destinationNlComponent.getModel().getFacet());
        if (schema.getDestinationType(destinationNlComponent.getTagName()) == null) {
            return;
        }
        final NlComponent myNlComponent = this.getComponent().getNlComponent();
        final NlModel myModel = myNlComponent.getModel();
        new WriteCommandAction(myModel.getProject(), "Create Action", new PsiFile[]{myModel.getFile()}){

            protected void run(@NotNull Result result) throws Throwable {
                XmlTag tag = myNlComponent.getTag().createChildTag("action", null, null, false);
                NlComponent newComponent = myModel.createComponent(tag, myNlComponent, null);
                NlComponentHelperKt.ensureId(newComponent);
                newComponent.setAttribute("http://schemas.android.com/apk/res-auto", "destination", "@id/" + destinationNlComponent.getId());
            }
        }.execute();
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        DrawCommand drawCommand = this.myIsDragging ? this.createDrawActionHandleDrag(sceneContext) : this.createDrawActionHandle(sceneContext);
        list.add(drawCommand);
    }

    private DrawCommand createDrawActionHandleDrag(@NotNull SceneContext sceneContext) {
        return new DrawActionHandleDrag(this.getSwingCenterX(sceneContext), this.getSwingCenterY(sceneContext), sceneContext.getColorSet().getSelectedFrames());
    }

    private DrawCommand createDrawActionHandle(@NotNull SceneContext sceneContext) {
        int newRadius = 0;
        if (this.mIsOver) {
            newRadius = 12;
        } else if (this.getComponent().getDrawState() == SceneComponent.DrawState.HOVER || this.getComponent().isSelected()) {
            newRadius = 8;
        }
        Color fillColor = sceneContext.getColorSet().getBackground();
        DrawActionHandle drawCommand = new DrawActionHandle(this.getSwingCenterX(sceneContext), this.getSwingCenterY(sceneContext), this.myCurrentRadius, newRadius, this.getFrameColor(sceneContext), fillColor);
        this.myCurrentRadius = newRadius;
        return drawCommand;
    }

    @Override
    public void addHit(@NotNull SceneContext transform, @NotNull ScenePicker picker) {
        picker.addCircle(this, 0, this.getSwingCenterX(transform), this.getSwingCenterY(transform), 12);
    }

    @Override
    public Cursor getMouseCursor() {
        return Cursor.getPredefinedCursor(12);
    }
}

