/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.targets;

import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.ScenePicker;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.BaseTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.naveditor.scene.draw.DrawAction;
import com.google.common.collect.ImmutableList;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionTarget
extends BaseTarget {
    private Rectangle mySourceRect;
    private Rectangle myDestRect;
    private final NlComponent myNlComponent;
    private final SceneComponent myDestination;

    public ActionTarget(@NotNull SceneComponent component2, @NotNull SceneComponent destination, @NotNull NlComponent actionComponent) {
        this.setComponent(component2);
        this.myNlComponent = actionComponent;
        this.myDestination = destination;
    }

    @Override
    public boolean canChangeSelection() {
        return false;
    }

    @Override
    public void mouseRelease(int x, int y, @Nullable List<Target> closestTargets) {
        this.myNlComponent.getModel().getSelectionModel().setSelection((List<NlComponent>)ImmutableList.of((Object)this.myNlComponent));
    }

    @Override
    public int getPreferenceLevel() {
        return 0;
    }

    @Override
    public boolean layout(@NotNull SceneContext context, int l, int t, int r, int b) {
        return false;
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        Rectangle sourceRect = Coordinates.getSwingRectDip(sceneContext, this.getComponent().fillRect(null));
        String targetId = NlComponent.stripId(this.myNlComponent.getAttribute("http://schemas.android.com/apk/res-auto", "destination"));
        if (targetId == null) {
            return;
        }
        this.myDestRect = Coordinates.getSwingRectDip(sceneContext, this.myDestination.fillRect(null));
        this.mySourceRect = sourceRect;
        boolean selected = this.getComponent().getScene().getSelection().contains(this.myNlComponent);
        DrawAction.buildDisplayList(list, ConnectionType.NORMAL, sourceRect, this.myDestRect, selected ? DrawAction.DrawMode.SELECTED : DrawAction.DrawMode.NORMAL);
    }

    @Override
    public void addHit(@NotNull SceneContext transform, @NotNull ScenePicker picker) {
        if (this.mySourceRect == null || this.myDestRect == null) {
            return;
        }
        CurvePoints points = ActionTarget.getCurvePoints(this.mySourceRect, this.myDestRect);
        picker.addCurveTo(this, 5, points.p1.x, points.p1.y, points.p2.x, points.p2.y, points.p3.x, points.p3.y, points.p4.x, points.p4.y);
    }

    @NotNull
    public static CurvePoints getCurvePoints(@NotNull Rectangle source, @NotNull Rectangle dest) {
        ConnectionDirection sourceDirection = ConnectionDirection.RIGHT;
        ConnectionDirection destDirection = ConnectionDirection.LEFT;
        int startx = ActionTarget.getConnectionX(sourceDirection, source);
        int starty = ActionTarget.getConnectionY(sourceDirection, source);
        int endx = ActionTarget.getConnectionX(destDirection, dest);
        int endy = ActionTarget.getConnectionY(destDirection, dest);
        int dx = ActionTarget.getDestinationDx(destDirection);
        int dy = ActionTarget.getDestinationDy(destDirection);
        int scale_source = 100;
        int scale_dest = 100;
        CurvePoints result = new CurvePoints();
        result.dir = destDirection;
        result.p1 = new Point(startx, starty);
        result.p2 = new Point(startx + scale_source * sourceDirection.getDeltaX(), starty + scale_source * sourceDirection.getDeltaY());
        result.p3 = new Point(endx + dx + scale_dest * destDirection.getDeltaX(), endy + dy + scale_dest * destDirection.getDeltaY());
        result.p4 = new Point(endx + dx, endy + dy);
        return result;
    }

    private static int getConnectionX(@NotNull ConnectionDirection side, @NotNull Rectangle rect) {
        return rect.x + (1 + side.getDeltaX()) * rect.width / 2;
    }

    private static int getConnectionY(@NotNull ConnectionDirection side, @NotNull Rectangle rect) {
        return rect.y + (1 + side.getDeltaY()) * rect.height / 2;
    }

    public static int getDestinationDx(@NotNull ConnectionDirection side) {
        return side.getDeltaX() * 6;
    }

    public static int getDestinationDy(@NotNull ConnectionDirection side) {
        return side.getDeltaY() * 6;
    }

    public static enum ConnectionDirection {
        LEFT(-1, 0),
        RIGHT(1, 0),
        TOP(0, -1),
        BOTTOM(0, 1);

        private ConnectionDirection myOpposite;
        private final int myDeltaX;
        private final int myDeltaY;

        private ConnectionDirection(int deltaX, int deltaY) {
            this.myDeltaX = deltaX;
            this.myDeltaY = deltaY;
        }

        public int getDeltaX() {
            return this.myDeltaX;
        }

        public int getDeltaY() {
            return this.myDeltaY;
        }

        public ConnectionDirection getOpposite() {
            return this.myOpposite;
        }

        static {
            ConnectionDirection.LEFT.myOpposite = RIGHT;
            ConnectionDirection.RIGHT.myOpposite = LEFT;
            ConnectionDirection.TOP.myOpposite = BOTTOM;
            ConnectionDirection.BOTTOM.myOpposite = TOP;
        }
    }

    public static enum ConnectionType {
        NORMAL,
        SELF;

    }

    public static class CurvePoints {
        public Point p1;
        public Point p2;
        public Point p3;
        public Point p4;
        public ConnectionDirection dir;
    }
}

