/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.targets;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.TargetProvider;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.naveditor.scene.layout.ManualLayoutAlgorithm;
import com.android.tools.idea.naveditor.scene.layout.NavSceneLayoutAlgorithm;
import com.android.tools.idea.naveditor.scene.targets.ActionHandleTarget;
import com.android.tools.idea.naveditor.scene.targets.ActionTarget;
import com.android.tools.idea.naveditor.scene.targets.ScreenDragTarget;
import com.android.tools.idea.naveditor.scene.targets.ScreenLabelTarget;
import com.android.tools.idea.naveditor.scene.targets.StartDestinationTarget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.annotations.NotNull;

public class NavScreenTargetProvider
implements TargetProvider {
    private final NavSceneLayoutAlgorithm myLayoutAlgorithm;
    private final NavigationSchema mySchema;

    public NavScreenTargetProvider(@NotNull NavSceneLayoutAlgorithm algorithm, @NotNull NavigationSchema schema) {
        this.myLayoutAlgorithm = algorithm;
        this.mySchema = schema;
    }

    @Override
    @NotNull
    public List<Target> createTargets(@NotNull SceneComponent sceneComponent, boolean isParent) {
        ArrayList<Target> result = new ArrayList<Target>();
        SceneComponent parent = sceneComponent.getParent();
        if (this.mySchema.getDestinationType(sceneComponent.getNlComponent().getTagName()) == null || parent == null) {
            return result;
        }
        HashMap groupMap = new HashMap();
        for (SceneComponent sibling : parent.getChildren()) {
            if (sibling == sceneComponent) continue;
            sibling.flatten().forEach(component2 -> groupMap.put(component2.getId(), sibling));
        }
        sceneComponent.getNlComponent().flatten().filter(component2 -> component2.getTagName().equals("action")).forEach(nlChild -> {
            String destinationId = NlComponent.stripId(nlChild.getAttribute("http://schemas.android.com/apk/res-auto", "destination"));
            SceneComponent destination = (SceneComponent)groupMap.get(destinationId);
            if (destination != null) {
                result.add(new ActionTarget(sceneComponent, destination, (NlComponent)nlChild));
            }
        });
        if (this.myLayoutAlgorithm instanceof ManualLayoutAlgorithm) {
            result.add(new ScreenDragTarget(sceneComponent, (ManualLayoutAlgorithm)this.myLayoutAlgorithm));
        }
        result.add(new ActionHandleTarget(sceneComponent));
        result.add(new ScreenLabelTarget(sceneComponent));
        NlComponent parentNlComponent = parent.getNlComponent();
        String startDestination = parentNlComponent.getAttribute("http://schemas.android.com/apk/res-auto", "startDestination");
        startDestination = NlComponent.stripId(startDestination);
        if (startDestination != null && startDestination.equals(sceneComponent.getId())) {
            result.add(new StartDestinationTarget(sceneComponent));
        }
        return result;
    }
}

