/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.targets;

import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.target.DragBaseTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.naveditor.scene.layout.ManualLayoutAlgorithm;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.MultiComponentTarget;
import java.awt.Cursor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScreenDragTarget
extends DragBaseTarget
implements MultiComponentTarget {
    private final ManualLayoutAlgorithm myAlgorithm;

    public ScreenDragTarget(@NotNull SceneComponent component2, @NotNull ManualLayoutAlgorithm algorithm) {
        this.setComponent(component2);
        this.myAlgorithm = algorithm;
    }

    @Override
    protected void updateAttributes(@NotNull AttributesTransaction attributes, int x, int y) {
    }

    @Override
    public void mouseDrag(int x, int y, @Nullable List<Target> closestTarget) {
        if (this.myComponent.getParent() == null) {
            return;
        }
        this.myComponent.setDragging(true);
        int dx = x - this.myOffsetX;
        int dy = y - this.myOffsetY;
        this.myComponent.setPosition(dx, dy);
        this.myComponent.getScene().needsLayout(1);
        this.myChangedComponent = true;
    }

    @Override
    public void mouseRelease(int x, int y, @Nullable List<Target> closestTargets) {
        if (!this.myComponent.isDragging()) {
            return;
        }
        this.myComponent.setDragging(false);
        if (this.myComponent.getParent() != null) {
            if (Math.abs(x - this.myFirstMouseX) <= 1 && Math.abs(y - this.myFirstMouseY) <= 1) {
                return;
            }
            this.myAlgorithm.save(this.myComponent);
        }
        if (this.myChangedComponent) {
            this.myComponent.getScene().needsLayout(1);
        }
    }

    @Override
    public Cursor getMouseCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    @Override
    public String getToolTipText() {
        return "Screen";
    }
}

