/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.structure;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.adtui.workbench.AutoHide;
import com.android.tools.adtui.workbench.Side;
import com.android.tools.adtui.workbench.Split;
import com.android.tools.adtui.workbench.ToolContent;
import com.android.tools.adtui.workbench.ToolWindowDefinition;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionListener;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.naveditor.NavComponentHelperKt;
import com.android.tools.idea.naveditor.surface.NavDesignSurface;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.sherpa.drawing.ColorSet;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import icons.AndroidIcons;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.annotations.NotNull;

public class DestinationList
extends JPanel
implements ToolContent<DesignSurface> {
    static final String ROOT_NAME = "Root";
    final DefaultListModel<NlComponent> myListModel = new DefaultListModel();
    private NavigationSchema mySchema;
    private ResourceResolver myResourceResolver;
    SelectionModel mySelectionModel;
    public final JBList<NlComponent> myList;
    private boolean mySelectionUpdating;
    private SelectionListener mySelectionModelListener;
    private ModelListener myModelListener;
    private NlModel myModel;
    private ListSelectionListener myListSelectionListener;
    private MouseListener myMouseListener;
    public JLabel myBackLabel;
    JPanel myBackPanel;
    private NavDesignSurface myDesignSurface;

    private DestinationList() {
        this.setLayout(new BorderLayout());
        this.myList = new JBList(this.myListModel);
        this.myList.setName("DestinationList");
        this.myList.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                NlComponent component2 = (NlComponent)value;
                String label = component2.getAttribute("http://schemas.android.com/apk/res/android", "label");
                if (label != null) {
                    label = ResourceHelper.resolveStringValue((RenderResources)DestinationList.this.myResourceResolver, label);
                }
                if (label == null) {
                    label = component2.getId();
                }
                this.setText(label);
                Icon icon = AndroidIcons.NavEditorIcons.Destination;
                if (DestinationList.this.mySchema.getDestinationType(component2.getTagName()) == NavigationSchema.DestinationType.NAVIGATION) {
                    icon = AndroidIcons.NavEditorIcons.DestinationGroup;
                }
                this.setIcon(icon);
                return result;
            }
        });
        InputMap inputMap = this.getInputMap(1);
        String deleteDestinationKey = "deleteDestination";
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "deleteDestination");
        inputMap.put(KeyStroke.getKeyStroke(8, 0), "deleteDestination");
        this.getActionMap().put("deleteDestination", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                final List toDelete = DestinationList.this.myList.getSelectedValuesList();
                if (!toDelete.isEmpty()) {
                    new WriteCommandAction(DestinationList.this.myDesignSurface.getProject(), "Delete Destination" + (toDelete.size() > 1 ? "s" : ""), new PsiFile[]{DestinationList.this.myDesignSurface.getModel().getFile()}){

                        protected void run(@NotNull Result result) throws Throwable {
                            DestinationList.this.myDesignSurface.getModel().delete(toDelete);
                        }
                    }.execute();
                }
            }
        });
        JScrollPane pane = ScrollPaneFactory.createScrollPane(this.myList, (int)20, (int)30);
        pane.setBorder(null);
        this.add((Component)pane, "Center");
    }

    public void dispose() {
        this.mySelectionModel.removeListener(this.mySelectionModelListener);
        this.myModel.removeListener(this.myModelListener);
        this.myList.removeListSelectionListener(this.myListSelectionListener);
        this.myList.removeMouseListener(this.myMouseListener);
    }

    public void setToolContext(final DesignSurface toolContext) {
        this.myDesignSurface = (NavDesignSurface)toolContext;
        if (this.mySelectionModel != null && this.mySelectionModelListener != null) {
            this.mySelectionModel.removeListener(this.mySelectionModelListener);
        }
        if (this.myListSelectionListener != null) {
            this.myList.removeListSelectionListener(this.myListSelectionListener);
        }
        if (this.myModel != null && this.myModelListener != null) {
            this.myModel.removeListener(this.myModelListener);
        }
        if (toolContext != null) {
            this.add((Component)this.createBackPanel(toolContext), "North");
            this.myModel = toolContext.getModel();
            this.mySelectionModel = toolContext.getSelectionModel();
            this.mySelectionModelListener = (model, selection) -> {
                if (this.mySelectionUpdating) {
                    return;
                }
                try {
                    this.mySelectionUpdating = true;
                    HashSet<NlComponent> components = new HashSet<NlComponent>((Collection<NlComponent>)this.mySelectionModel.getSelection());
                    ArrayList<Integer> selectedIndices = new ArrayList<Integer>();
                    for (int i = 0; i < this.myListModel.size(); ++i) {
                        if (!components.contains(this.myListModel.get(i))) continue;
                        selectedIndices.add(i);
                    }
                    this.myList.setSelectedIndices(ArrayUtil.toIntArray(selectedIndices));
                    this.updateBackLabel();
                }
                finally {
                    this.mySelectionUpdating = false;
                }
            };
            this.mySelectionModel.addListener(this.mySelectionModelListener);
            this.myListSelectionListener = e -> {
                if (this.mySelectionUpdating) {
                    return;
                }
                try {
                    this.mySelectionUpdating = true;
                    this.mySelectionModel.setSelection(this.myList.getSelectedValuesList());
                }
                finally {
                    this.mySelectionUpdating = false;
                }
            };
            this.myList.addListSelectionListener(this.myListSelectionListener);
            this.myModelListener = new ModelListener(){

                @Override
                public void modelRendered(@NotNull NlModel model) {
                }

                @Override
                public void modelChanged(@NotNull NlModel model) {
                    DestinationList.this.updateComponentList(toolContext);
                }

                @Override
                public void modelActivated(@NotNull NlModel model) {
                    DestinationList.this.updateComponentList(toolContext);
                }

                @Override
                public void modelChangedOnLayout(@NotNull NlModel model, boolean animate) {
                }
            };
            this.myMouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        DestinationList.this.myDesignSurface.notifyComponentActivate((NlComponent)DestinationList.this.myList.getSelectedValue());
                    }
                }
            };
            this.myList.addMouseListener(this.myMouseListener);
            this.myModel.addListener(this.myModelListener);
            this.myResourceResolver = toolContext.getConfiguration().getResourceResolver();
        }
        this.updateComponentList(toolContext);
    }

    private NavigationSchema getSchema() {
        if (this.mySchema == null) {
            assert (this.myModel != null);
            this.mySchema = NavigationSchema.getOrCreateSchema(this.myModel.getFacet());
        }
        return this.mySchema;
    }

    private void updateBackLabel() {
        if (this.myModel.getComponents().contains((Object)this.myDesignSurface.getCurrentNavigation())) {
            this.myBackPanel.setVisible(false);
        } else {
            this.myBackPanel.setVisible(true);
            NlComponent parent = this.myDesignSurface.getCurrentNavigation().getParent();
            this.myBackLabel.setText(parent.getParent() == null ? ROOT_NAME : NavComponentHelperKt.getUiName(parent));
        }
    }

    @NotNull
    private JComponent createBackPanel(@NotNull DesignSurface context) {
        this.myBackPanel = new JPanel(new BorderLayout());
        this.myBackLabel = new JLabel("", StudioIcons.Common.BACK_ARROW, 2);
        ColorSet colorSet = SceneContext.get(context.getCurrentSceneView()).getColorSet();
        this.myBackPanel.setBackground(colorSet.getSubduedBackground());
        this.myBackPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, colorSet.getFrames()), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.myBackPanel.setVisible(false);
        this.myBackPanel.add((Component)this.myBackLabel, "West");
        this.myBackLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DestinationList.this.goBack();
            }
        });
        return this.myBackPanel;
    }

    void goBack() {
        this.myDesignSurface.setCurrentNavigation(this.myDesignSurface.getCurrentNavigation().getParent());
        this.updateComponentList(this.myDesignSurface);
        this.updateBackLabel();
    }

    private void updateComponentList(DesignSurface toolContext) {
        ArrayList<NlComponent> newElements = new ArrayList<NlComponent>();
        if (toolContext != null) {
            NlComponent root = this.myDesignSurface.getCurrentNavigation();
            for (NlComponent child : root.getChildren()) {
                if (this.getSchema().getDestinationType(child.getTagName()) == null) continue;
                newElements.add(child);
            }
        }
        if (!newElements.equals(Collections.list(this.myListModel.elements()))) {
            this.myListModel.clear();
            newElements.forEach(this.myListModel::addElement);
        }
    }

    @NotNull
    public JComponent getComponent() {
        return this;
    }

    public static class DestinationListDefinition
    extends ToolWindowDefinition<DesignSurface> {
        public DestinationListDefinition() {
            super("Destinations", AllIcons.Toolwindows.ToolWindowHierarchy, "destinations", Side.LEFT, Split.TOP, AutoHide.DOCKED, () -> new DestinationList());
        }
    }
}

