/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.surface;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneInteraction;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.SceneLayer;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.naveditor.editor.NavActionManager;
import com.android.tools.idea.naveditor.property.inspector.NavInspectorProviders;
import com.android.tools.idea.naveditor.scene.NavSceneManager;
import com.android.tools.idea.naveditor.surface.NavView;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.JBColor;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import javax.swing.JViewport;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavDesignSurface
extends DesignSurface {
    private NavView myNavView;
    private NavigationSchema mySchema;
    private NlComponent myCurrentNavigation;
    private double myOldScale = 0.0;

    public NavDesignSurface(@NotNull Project project, @NotNull Disposable parentDisposable) {
        super(project, parentDisposable);
        this.zoomActual();
        this.getScrollPane().getHorizontalScrollBar().addAdjustmentListener(event -> {
            if (this.myNavView != null && this.myNavView.getX() > 0) {
                JViewport viewport = this.getScrollPane().getViewport();
                int viewX = (int)viewport.getViewPosition().getX();
                this.myNavView.setLocation(this.myNavView.getX() - viewX, this.myNavView.getY());
                viewport.setViewPosition(new Point(0, (int)viewport.getViewPosition().getY()));
                if (this.getScene() != null) {
                    this.getScene().needsRebuildList();
                }
            }
            this.updateScrolledAreaSize();
        });
        this.getScrollPane().getVerticalScrollBar().addAdjustmentListener(event -> {
            if (this.myNavView != null && this.myNavView.getY() > 0) {
                JViewport viewport = this.getScrollPane().getViewport();
                int viewY = (int)viewport.getViewPosition().getY();
                this.myNavView.setLocation(this.myNavView.getX(), this.myNavView.getY() - viewY);
                viewport.setViewPosition(new Point((int)viewport.getViewPosition().getX(), 0));
                if (this.getScene() != null) {
                    this.getScene().needsRebuildList();
                }
                this.updateScrolledAreaSize();
            }
        });
    }

    @NotNull
    public NavigationSchema getSchema() {
        if (this.mySchema == null) {
            NlModel model = this.getModel();
            assert (model != null);
            this.mySchema = NavigationSchema.getOrCreateSchema(model.getFacet());
        }
        return this.mySchema;
    }

    @NotNull
    protected NavActionManager createActionManager() {
        return new NavActionManager(this);
    }

    @Override
    @NotNull
    protected SceneManager createSceneManager(@NotNull NlModel model) {
        return new NavSceneManager(model, this);
    }

    @Override
    @Nullable
    public NavSceneManager getSceneManager() {
        return (NavSceneManager)super.getSceneManager();
    }

    @Override
    @NotNull
    public NavInspectorProviders getInspectorProviders(@NotNull NlPropertiesManager propertiesManager, @NotNull Disposable parentDisposable) {
        return new NavInspectorProviders(propertiesManager, parentDisposable);
    }

    @Override
    protected void layoutContent() {
        this.requestRender();
    }

    @Override
    @NotNull
    protected JBColor getBackgroundColor() {
        return JBColor.white;
    }

    @NotNull
    public NlComponent getCurrentNavigation() {
        if ((this.myCurrentNavigation == null || this.myCurrentNavigation.getModel() != this.getModel()) && this.getModel() != null) {
            this.myCurrentNavigation = (NlComponent)this.getModel().getComponents().get(0);
        }
        return this.myCurrentNavigation;
    }

    public void setCurrentNavigation(@NotNull NlComponent currentNavigation) {
        this.myCurrentNavigation = currentNavigation;
        this.getSceneManager().update();
        this.getSelectionModel().clear();
        this.getSceneManager().layout(false);
        currentNavigation.getModel().notifyModified(NlModel.ChangeType.UPDATE_HIERARCHY);
        this.repaint();
    }

    @Override
    protected void doCreateSceneViews() {
        NlModel model = this.getModel();
        if (model == null && this.myNavView == null) {
            return;
        }
        this.myNavView = null;
        if (model != null) {
            this.myNavView = new NavView(this, model);
            this.setLayers((ImmutableList<Layer>)ImmutableList.of((Object)new SceneLayer(this, this.myNavView, true)));
            this.getLayeredPane().setPreferredSize(this.myNavView.getPreferredSize());
            this.layoutContent();
        }
        this.setShowIssuePanel(false);
    }

    @Override
    @Nullable
    public Dimension getScrolledAreaSize() {
        Dimension content = this.getContentSize(null);
        SceneView view = this.getCurrentSceneView();
        if (this.myOldScale != this.myScale || view == null) {
            this.myOldScale = this.myScale;
            return content;
        }
        Dimension viewExtents = this.getScrollPane().getViewport().getExtentSize();
        Point viewPosition = this.getScrollPosition();
        return new Dimension((int)Math.max(viewPosition.getX() + viewExtents.getWidth(), (double)this.getCurrentSceneView().getX() + content.getWidth()), (int)Math.max(viewPosition.getY() + viewExtents.getHeight(), (double)this.getCurrentSceneView().getY() + content.getHeight()));
    }

    @Override
    @Nullable
    public SceneView getCurrentSceneView() {
        return this.myNavView;
    }

    @Override
    @NotNull
    public Dimension getContentSize(@Nullable Dimension dimension) {
        SceneView view = this.getCurrentSceneView();
        if (view == null) {
            Dimension dim = dimension == null ? new Dimension() : dimension;
            dim.setSize(0, 0);
            return dim;
        }
        return view.getSize(dimension);
    }

    @Override
    protected Dimension getDefaultOffset() {
        return new Dimension(20, 20);
    }

    @Override
    @NotNull
    protected Dimension getPreferredContentSize(int availableWidth, int availableHeight) {
        if (this.getCurrentSceneView() == null) {
            return new Dimension(availableWidth, availableHeight);
        }
        return this.getCurrentSceneView().getPreferredSize();
    }

    @Override
    public boolean isLayoutDisabled() {
        return false;
    }

    @Override
    protected int getContentOriginX() {
        return 0;
    }

    @Override
    protected int getContentOriginY() {
        return 0;
    }

    @Override
    public void notifyComponentActivate(@NotNull NlComponent component2) {
        if (this.getSchema().getDestinationType(component2.getTagName()) == NavigationSchema.DestinationType.NAVIGATION) {
            this.setCurrentNavigation(component2);
        } else {
            VirtualFile virtualFile;
            PsiFile file;
            PsiClass psiClass;
            String className;
            String layout = component2.getAttribute("http://schemas.android.com/tools", "layout");
            if (layout != null) {
                VirtualFile virtualFile2;
                File file2;
                String fileName;
                Configuration configuration = this.getConfiguration();
                ResourceResolver resolver = configuration != null ? configuration.getResourceResolver() : null;
                ResourceValue value = resolver != null ? resolver.findResValue(layout, false) : null;
                String string = fileName = value != null ? value.getValue() : null;
                if (fileName != null && (file2 = new File(fileName)).exists() && (virtualFile2 = VfsUtil.findFileByIoFile((File)file2, (boolean)false)) != null) {
                    FileEditorManager.getInstance((Project)this.getProject()).openFile(virtualFile2, true);
                    return;
                }
            }
            if ((className = component2.getAttribute("http://schemas.android.com/apk/res/android", "name")) != null && (psiClass = JavaPsiFacade.getInstance((Project)this.getProject()).findClass(className, GlobalSearchScope.allScope((Project)this.getProject()))) != null && (file = psiClass.getContainingFile()) != null && (virtualFile = file.getVirtualFile()) != null) {
                FileEditorManager.getInstance((Project)this.getProject()).openFile(virtualFile, true);
                return;
            }
        }
        super.notifyComponentActivate(component2);
    }

    @Override
    @Nullable
    public Interaction doCreateInteractionOnClick(int mouseX, int mouseY, @NotNull SceneView view) {
        return new SceneInteraction(view);
    }

    @Override
    @Nullable
    public Interaction createInteractionOnDrag(@NotNull SceneComponent draggedSceneComponent, @Nullable SceneComponent primary) {
        return null;
    }
}

