/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator;

import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.navigator.AndroidProjectTreeBuilder;
import com.android.tools.idea.navigator.nodes.AndroidViewProjectNode;
import com.android.tools.idea.navigator.nodes.FileGroupNode;
import com.android.tools.idea.navigator.nodes.FolderGroupNode;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.impl.ProjectViewSelectInTarget;
import com.intellij.ide.projectView.BaseProjectTreeBuilder;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectViewPSIPane;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.ProjectTreeStructure;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.projectView.impl.nodes.PackageElement;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import icons.AndroidIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProjectViewPane
extends AbstractProjectViewPSIPane {
    public static final String ID = "AndroidView";
    public static final DataKey<TreeNode[]> SELECTED_TREE_NODES = DataKey.create((String)"selectedTreeNodes");

    public AndroidProjectViewPane(Project project) {
        super(project);
    }

    public String getTitle() {
        return "Android";
    }

    public Icon getIcon() {
        return AndroidIcons.Android;
    }

    @NotNull
    public String getId() {
        return ID;
    }

    public int getWeight() {
        return 142;
    }

    @NotNull
    public static List<IdeaSourceProvider> getSourceProviders(@NotNull AndroidFacet facet) {
        List<IdeaSourceProvider> sourceProviders = IdeaSourceProvider.getCurrentSourceProviders(facet);
        sourceProviders.addAll(IdeaSourceProvider.getCurrentTestSourceProviders(facet));
        return sourceProviders;
    }

    public SelectInTarget createSelectInTarget() {
        return new ProjectViewSelectInTarget(this.myProject){

            public String toString() {
                return AndroidProjectViewPane.this.getTitle();
            }

            public String getMinorViewId() {
                return AndroidProjectViewPane.this.getId();
            }

            public float getWeight() {
                return AndroidProjectViewPane.this.getWeight();
            }
        };
    }

    protected ProjectAbstractTreeStructureBase createStructure() {
        return new ProjectTreeStructure(this.myProject, ID){

            protected AbstractTreeNode createRoot(Project project, ViewSettings settings) {
                return new AndroidViewProjectNode(project, settings, AndroidProjectViewPane.this);
            }
        };
    }

    @NotNull
    protected BaseProjectTreeBuilder createBuilder(DefaultTreeModel treeModel) {
        return new AndroidProjectTreeBuilder(this.myProject, (JTree)this.myTree, treeModel, (ProjectAbstractTreeStructureBase)this.myTreeStructure, null);
    }

    protected ProjectViewTree createTree(DefaultTreeModel treeModel) {
        return new MyProjectViewTree(treeModel);
    }

    protected AbstractTreeUpdater createTreeUpdater(AbstractTreeBuilder treeBuilder) {
        return new AbstractTreeUpdater(treeBuilder);
    }

    @NotNull
    public PsiDirectory[] getSelectedDirectories() {
        PackageElement packageElement;
        Module m;
        Object selectedElement = this.getSelectedElement();
        if (selectedElement instanceof PackageElement && (m = (packageElement = (PackageElement)selectedElement).getModule()) != null) {
            return packageElement.getPackage().getDirectories(GlobalSearchScope.moduleScope((Module)m));
        }
        NodeDescriptor descriptor = this.getSelectedDescriptor();
        if (descriptor instanceof FolderGroupNode) {
            return ((FolderGroupNode)descriptor).getFolders();
        }
        PsiDirectory[] selectedDirectories = super.getSelectedDirectories();
        if (selectedElement instanceof Module && selectedDirectories.length > 0) {
            ArrayList<PsiDirectory> dirs = new ArrayList<PsiDirectory>(selectedDirectories.length);
            for (PsiDirectory dir : selectedDirectories) {
                VirtualFile file = dir.getVirtualFile();
                if (GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)file, (Project)this.myProject) || file.getParent() != null && file.getPath().contains("/generated/")) continue;
                dirs.add(dir);
            }
            selectedDirectories = dirs.toArray(new PsiDirectory[dirs.size()]);
        }
        return selectedDirectories;
    }

    protected Object exhumeElementFromNode(DefaultMutableTreeNode node) {
        Object o = super.exhumeElementFromNode(node);
        if (o instanceof ArrayList && node.getUserObject() instanceof FolderGroupNode) {
            return ((ArrayList)o).toArray();
        }
        return o;
    }

    public Object getData(String dataId) {
        Module m;
        PackageElement packageElement;
        VirtualFile directory;
        Object o;
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId) && (o = this.getSelectedElement()) instanceof PsiDirectory && this.isTopModuleDirectoryOrParent(directory = ((PsiDirectory)o).getVirtualFile())) {
            return new NoOpDeleteProvider();
        }
        if (LangDataKeys.MODULE.is(dataId)) {
            o = this.getSelectedElement();
            if (o instanceof PackageElement) {
                packageElement = (PackageElement)o;
                return packageElement.getModule();
            }
            if (o instanceof AndroidFacet) {
                return ((AndroidFacet)((Object)o)).getModule();
            }
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId) && (o = this.getSelectedElement()) instanceof PackageElement && (m = (packageElement = (PackageElement)o).getModule()) != null) {
            PsiDirectory[] folders = packageElement.getPackage().getDirectories(GlobalSearchScope.moduleScope((Module)m));
            if (folders.length > 0) {
                return folders[0].getVirtualFile();
            }
            return null;
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            PsiDirectory[] directories;
            ArrayList<VirtualFile> virtualFiles;
            PsiFile[] files;
            NodeDescriptor selectedDescriptor = this.getSelectedDescriptor();
            if (selectedDescriptor instanceof FileGroupNode && (files = ((FileGroupNode)selectedDescriptor).getFiles()).length > 0) {
                virtualFiles = new ArrayList<VirtualFile>(files.length);
                for (PsiFile file : files) {
                    if (!file.isValid()) continue;
                    virtualFiles.add(file.getVirtualFile());
                }
                return virtualFiles.toArray(new VirtualFile[virtualFiles.size()]);
            }
            if (selectedDescriptor instanceof FolderGroupNode && (directories = ((FolderGroupNode)selectedDescriptor).getFolders()).length > 0) {
                virtualFiles = new ArrayList(directories.length);
                for (PsiDirectory directory2 : directories) {
                    if (!directory2.isValid()) continue;
                    virtualFiles.add(directory2.getVirtualFile());
                }
                return virtualFiles.toArray(new VirtualFile[virtualFiles.size()]);
            }
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            PsiDirectory[] directories;
            PsiFile[] files;
            List l;
            o = this.getSelectedElement();
            if (o instanceof PsiElement) {
                return o;
            }
            if (o instanceof List && !(l = (List)o).isEmpty() && l.get(0) instanceof PsiElement) {
                return l.get(0);
            }
            NodeDescriptor selectedDescriptor = this.getSelectedDescriptor();
            if (selectedDescriptor instanceof FileGroupNode && (files = ((FileGroupNode)selectedDescriptor).getFiles()).length > 0) {
                return files[0];
            }
            if (selectedDescriptor instanceof FolderGroupNode && (directories = ((FolderGroupNode)selectedDescriptor).getFolders()).length > 0) {
                return directories[0];
            }
        }
        if (SELECTED_TREE_NODES.is(dataId)) {
            return this.getSelectedTreeNodes();
        }
        return super.getData(dataId);
    }

    @Nullable
    private TreeNode[] getSelectedTreeNodes() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return null;
        }
        ArrayList<TreeNode> result = new ArrayList<TreeNode>();
        for (TreePath path : paths) {
            Object lastPathComponent = path.getLastPathComponent();
            if (!(lastPathComponent instanceof DefaultMutableTreeNode)) continue;
            result.add((TreeNode)lastPathComponent);
        }
        return result.toArray(new TreeNode[result.size()]);
    }

    private boolean isTopModuleDirectoryOrParent(@NotNull VirtualFile directory) {
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            File baseDirPath;
            File moduleRootFolderPath = Projects.findModuleRootFolderPath(module);
            if (moduleRootFolderPath == null || !FileUtil.filesEqual((File)moduleRootFolderPath, (File)(baseDirPath = Projects.getBaseDirPath(this.myProject)))) continue;
            File directoryPath = VfsUtilCore.virtualToIoFile((VirtualFile)directory);
            return FileUtil.isAncestor((File)directoryPath, (File)baseDirPath, (boolean)false);
        }
        return false;
    }

    private static class NoOpDeleteProvider
    implements DeleteProvider {
        private NoOpDeleteProvider() {
        }

        public void deleteElement(@NotNull DataContext dataContext) {
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            return false;
        }
    }

    private class MyProjectViewTree
    extends ProjectViewTree
    implements DataProvider {
        public MyProjectViewTree(DefaultTreeModel treeModel) {
            super(AndroidProjectViewPane.this.myProject, (TreeModel)treeModel);
        }

        public DefaultMutableTreeNode getSelectedNode() {
            return AndroidProjectViewPane.this.getSelectedNode();
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            return AndroidProjectViewPane.this.getData(dataId);
        }
    }
}

