/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidViewNodes {
    @Nullable
    public <T> T selectNodeOfType(@NotNull Class<T> nodeType, @NotNull Project project) {
        ToolWindow projectToolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Project");
        if (projectToolWindow != null) {
            return this.selectNodeOfType(nodeType, project, projectToolWindow);
        }
        return null;
    }

    <T> T selectNodeOfType(@NotNull Class<T> nodeType, @NotNull Project project, @NotNull ToolWindow projectToolWindow) {
        Ref nodeRef = new Ref();
        projectToolWindow.activate(() -> {
            Object found = AndroidViewNodes.performOnNodeOfType(nodeType, (node, treeBuilder) -> treeBuilder.select(node), project);
            nodeRef.set(found);
        });
        return (T)nodeRef.get();
    }

    @Nullable
    public <T> T findAndRefreshNodeOfType(@NotNull Class<T> nodeType, @NotNull Project project) {
        return (T)AndroidViewNodes.performOnNodeOfType(nodeType, (node, treeBuilder) -> treeBuilder.queueUpdateFrom(node, false), project);
    }

    @Nullable
    private static <T> T performOnNodeOfType(@NotNull Class<T> nodeType, @NotNull PerformOnNodeTask<T> task, @NotNull Project project) {
        ProjectView projectView = ProjectView.getInstance((Project)project);
        AbstractProjectViewPane androidViewPane = projectView.getProjectViewPaneById("AndroidView");
        assert (androidViewPane != null);
        AbstractTreeBuilder treeBuilder = androidViewPane.getTreeBuilder();
        if (!treeBuilder.isDisposed()) {
            Ref nodeRef = new Ref();
            ApplicationManager.getApplication().runReadAction(() -> treeBuilder.accept(nodeType, node -> {
                nodeRef.set(node);
                return true;
            }));
            Object node = nodeRef.get();
            if (node != null) {
                task.perform(node, treeBuilder);
                return (T)node;
            }
        }
        return null;
    }

    private static interface PerformOnNodeTask<T> {
        public void perform(@NotNull T var1, @NotNull AbstractTreeBuilder var2);
    }
}

