/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.navigator.nodes.android.AndroidBuildScriptsGroupNode;
import com.android.tools.idea.navigator.nodes.android.AndroidModuleNode;
import com.android.tools.idea.navigator.nodes.apk.ApkModuleNode;
import com.android.tools.idea.navigator.nodes.ndk.ExternalBuildFilesGroupNode;
import com.android.tools.idea.navigator.nodes.ndk.NdkModuleNode;
import com.android.tools.idea.navigator.nodes.other.NonAndroidModuleNode;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ExternalLibrariesNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidViewProjectNode
extends ProjectViewNode<Project> {
    private final AndroidProjectViewPane myProjectViewPane;

    public AndroidViewProjectNode(@NotNull Project project, @NotNull ViewSettings settings, @NotNull AndroidProjectViewPane projectViewPane) {
        super(project, (Object)project, settings);
        this.myProjectViewPane = projectViewPane;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        ExternalBuildFilesGroupNode externalBuildFilesNode;
        PsiDirectory folder;
        assert (this.myProject != null);
        ViewSettings settings = this.getSettings();
        List<Module> modules = Arrays.asList(ModuleManager.getInstance((Project)this.myProject).getModules());
        ArrayList<Object> children = new ArrayList<Object>(modules.size());
        for (Module module : modules) {
            ApkFacet apkFacet = ApkFacet.getInstance(module);
            if (GradleUtil.isRootModuleWithNoSources(module) && apkFacet == null) continue;
            AndroidFacet androidFacet = AndroidFacet.getInstance(module);
            NdkFacet ndkFacet = NdkFacet.getInstance(module);
            if (androidFacet != null && androidFacet.getAndroidModel() != null) {
                children.add((Object)new AndroidModuleNode(this.myProject, module, settings, this.myProjectViewPane));
                continue;
            }
            if (androidFacet != null && apkFacet != null) {
                children.add((Object)new ApkModuleNode(this.myProject, module, androidFacet, apkFacet, settings));
                children.add(new ExternalLibrariesNode(this.myProject, settings));
                continue;
            }
            if (ndkFacet != null && ndkFacet.getNdkModuleModel() != null) {
                children.add((Object)new NdkModuleNode(this.myProject, module, settings));
                continue;
            }
            children.add((Object)new NonAndroidModuleNode(this.myProject, module, settings));
        }
        boolean buildWithGradle = GradleProjectInfo.getInstance(this.myProject).isBuildWithGradle();
        if (children.isEmpty() && buildWithGradle && GradleSyncState.getInstance(this.myProject).lastSyncFailed() && (folder = PsiManager.getInstance((Project)this.myProject).findDirectory(this.myProject.getBaseDir())) != null) {
            children.add(new PsiDirectoryNode(this.myProject, folder, settings));
        }
        if (buildWithGradle) {
            children.add((Object)new AndroidBuildScriptsGroupNode(this.myProject, settings));
        }
        if (!(externalBuildFilesNode = new ExternalBuildFilesGroupNode(this.myProject, settings)).getChildren().isEmpty()) {
            children.add((Object)externalBuildFilesNode);
        }
        return children;
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        assert (this.myProject != null);
        return String.format("%1$s", this.myProject.getName());
    }

    public boolean equals(Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        return super.equals(o);
    }

    protected void update(@NotNull PresentationData presentation) {
        presentation.setIcon(PlatformIcons.PROJECT_ICON);
        Project project = this.getProject();
        assert (project != null);
        presentation.setPresentableText(project.getName());
    }

    public boolean contains(@NotNull VirtualFile file) {
        assert (this.myProject != null);
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        VirtualFile projectRootFolder = this.myProject.getBaseDir();
        return index.isInContent(file) || index.isInLibraryClasses(file) || index.isInLibrarySource(file) || projectRootFolder != null && VfsUtilCore.isAncestor((VirtualFile)projectRootFolder, (VirtualFile)file, (boolean)false);
    }
}

