/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidBuildScriptNode
extends PsiFileNode {
    static final String MODULE_PREFIX = "Module: ";
    static final String PROJECT_PREFIX = "Project: ";
    @Nullable
    private final String myQualifier;

    AndroidBuildScriptNode(@NotNull Project project, @NotNull PsiFile value, @NotNull ViewSettings settings, @Nullable String qualifier) {
        super(project, value, settings);
        this.myQualifier = qualifier;
    }

    public void update(@NotNull PresentationData data) {
        super.update(data);
        PsiFile psiFile = (PsiFile)this.getValue();
        if (psiFile != null && psiFile.isValid()) {
            String fileName = psiFile.getName();
            data.addText(fileName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            data.setPresentableText(fileName);
            if (this.myQualifier != null) {
                data.addText(" (" + this.myQualifier + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
        }
    }

    @Nullable
    public Comparable getSortKey() {
        String priority;
        if (this.myQualifier != null) {
            priority = this.myQualifier.startsWith(PROJECT_PREFIX) ? "1-" : (this.myQualifier.startsWith(MODULE_PREFIX) ? "2-" : "3-");
            priority = priority + this.myQualifier + "-";
        } else {
            priority = "4-";
        }
        PsiFile file = (PsiFile)this.getValue();
        return file != null ? priority + file.getName() : priority;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        PsiFile value = (PsiFile)this.getValue();
        String fileName = value != null ? value.getName() : "";
        return fileName + (this.myQualifier == null ? "" : " (" + this.myQualifier + ")");
    }
}

