/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.navigator.nodes.FolderGroupNode;
import com.android.tools.idea.navigator.nodes.ndk.NdkModuleNode;
import com.android.tools.idea.navigator.nodes.ndk.NdkSourceFolderNode;
import com.google.common.collect.Iterables;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.ui.SimpleTextAttributes;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidSourceType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidJniFolderNode
extends ProjectViewNode<NdkModuleModel>
implements FolderGroupNode {
    AndroidJniFolderNode(@NotNull Project project, @NotNull NdkModuleModel ndkModuleModel, @NotNull ViewSettings settings) {
        super(project, (Object)ndkModuleModel, settings);
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        AbstractTreeNode sourceNode;
        assert (this.myProject != null);
        Collection<AbstractTreeNode> nativeSourceNodes = NdkModuleNode.getNativeSourceNodes(this.myProject, this.getNdkModel(), this.getSettings());
        if (nativeSourceNodes.size() == 1 && (sourceNode = (AbstractTreeNode)Iterables.getOnlyElement(nativeSourceNodes)) instanceof NdkSourceFolderNode) {
            return ((NdkSourceFolderNode)sourceNode).getChildren();
        }
        return nativeSourceNodes;
    }

    @Override
    @NotNull
    public PsiDirectory[] getFolders() {
        Collection<File> sourceFolderPaths = this.getNdkModel().getSelectedVariant().getSourceFolders();
        ArrayList<PsiDirectory> folders = new ArrayList<PsiDirectory>(sourceFolderPaths.size());
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        assert (this.myProject != null);
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        for (File sourceFolderPath : sourceFolderPaths) {
            PsiDirectory psiSourceFolder;
            VirtualFile sourceFolder = fileSystem.findFileByIoFile(sourceFolderPath);
            if (sourceFolder == null || (psiSourceFolder = psiManager.findDirectory(sourceFolder)) == null) continue;
            folders.add(psiSourceFolder);
        }
        return folders.toArray(new PsiDirectory[folders.size()]);
    }

    public boolean contains(@NotNull VirtualFile file) {
        Collection<File> sourceFolders = this.getNdkModel().getSelectedVariant().getSourceFolders();
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        for (File folder : sourceFolders) {
            VirtualFile virtualFile = fileSystem.findFileByIoFile(folder);
            if (virtualFile == null || !VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    protected void update(PresentationData presentation) {
        presentation.addText(AndroidSourceType.CPP.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        Icon icon = AndroidSourceType.CPP.getIcon();
        if (icon != null) {
            presentation.setIcon(icon);
        }
        presentation.setPresentableText(AndroidSourceType.CPP.getName());
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return AndroidSourceType.CPP.getName();
    }

    @Nullable
    public Comparable getSortKey() {
        return AndroidSourceType.CPP;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return AndroidSourceType.CPP;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AndroidJniFolderNode that = (AndroidJniFolderNode)o;
        return this.getValue() == that.getValue();
    }

    public int hashCode() {
        int result = super.hashCode();
        return 31 * result + this.getNdkModel().hashCode();
    }

    @NotNull
    private NdkModuleModel getNdkModel() {
        NdkModuleModel value = (NdkModuleModel)this.getValue();
        assert (value != null);
        return value;
    }
}

