/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.navigator.nodes.android.AndroidJniFolderNode;
import com.android.tools.idea.navigator.nodes.android.AndroidManifestsGroupNode;
import com.android.tools.idea.navigator.nodes.android.AndroidResFolderNode;
import com.android.tools.idea.navigator.nodes.android.AndroidSourceTypeNode;
import com.android.tools.idea.res.SampleDataResourceRepository;
import com.google.common.collect.HashMultimap;
import com.intellij.codeInsight.dataflow.SetUtil;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidSourceType;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidModuleNode
extends ProjectViewModuleNode {
    private final AndroidProjectViewPane myProjectViewPane;

    public AndroidModuleNode(@NotNull Project project, @NotNull Module module, @NotNull ViewSettings settings, @NotNull AndroidProjectViewPane projectViewPane) {
        super(project, module, settings);
        this.myProjectViewPane = projectViewPane;
    }

    @NotNull
    private Module getModule() {
        Module module = (Module)this.getValue();
        assert (module != null);
        return module;
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        AndroidFacet facet = AndroidFacet.getInstance(this.getModule());
        if (facet == null || facet.getAndroidModel() == null) {
            return super.getChildren();
        }
        return AndroidModuleNode.getChildren(facet, this.getSettings(), this.myProjectViewPane, AndroidProjectViewPane.getSourceProviders(facet));
    }

    @NotNull
    static Collection<AbstractTreeNode> getChildren(@NotNull AndroidFacet facet, @NotNull ViewSettings settings, @NotNull AndroidProjectViewPane projectViewPane, @NotNull List<IdeaSourceProvider> providers) {
        Project project = facet.getModule().getProject();
        ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>();
        AndroidModuleModel androidModuleModel = AndroidModuleModel.get(facet);
        HashMultimap<AndroidSourceType, VirtualFile> sourcesByType = AndroidModuleNode.getSourcesBySourceType(providers, androidModuleModel);
        NdkModuleModel ndkModuleModel = NdkModuleModel.get(facet.getModule());
        for (AndroidSourceType sourceType : sourcesByType.keySet()) {
            if (sourceType == AndroidSourceType.CPP && ndkModuleModel != null) continue;
            if (sourceType == AndroidSourceType.MANIFEST) {
                result.add((AbstractTreeNode)new AndroidManifestsGroupNode(project, facet, settings, sourcesByType.get((Object)sourceType)));
                continue;
            }
            if (sourceType == AndroidSourceType.RES) {
                result.add((AbstractTreeNode)new AndroidResFolderNode(project, facet, settings, sourcesByType.get((Object)sourceType), projectViewPane));
                continue;
            }
            if (sourceType == AndroidSourceType.SHADERS && (androidModuleModel == null || !androidModuleModel.getFeatures().isShadersSupported())) continue;
            result.add((AbstractTreeNode)new AndroidSourceTypeNode(project, facet, settings, sourceType, sourcesByType.get((Object)sourceType), projectViewPane));
        }
        if (ndkModuleModel != null) {
            result.add((AbstractTreeNode)new AndroidJniFolderNode(project, ndkModuleModel, settings));
        }
        if (StudioFlags.NELE_SAMPLE_DATA.get().booleanValue()) {
            try {
                PsiDirectory sampleDataPsi;
                VirtualFile sampleDataDirectory = SampleDataResourceRepository.getSampleDataDir(facet, false);
                PsiDirectory psiDirectory = sampleDataPsi = sampleDataDirectory != null ? PsiManager.getInstance((Project)project).findDirectory(sampleDataDirectory) : null;
                if (sampleDataPsi != null) {
                    result.add((AbstractTreeNode)new PsiDirectoryNode(project, sampleDataPsi, settings));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    @NotNull
    private static HashMultimap<AndroidSourceType, VirtualFile> getSourcesBySourceType(@NotNull List<IdeaSourceProvider> providers, @Nullable AndroidModuleModel androidModel) {
        HashMultimap sourcesByType = HashMultimap.create();
        HashSet<VirtualFile> allSources = new HashSet<VirtualFile>();
        for (AndroidSourceType sourceType : AndroidSourceType.values()) {
            Set<VirtualFile> sources;
            if (sourceType == AndroidSourceType.SHADERS && (androidModel == null || !androidModel.getFeatures().isShadersSupported()) || (sources = AndroidModuleNode.getSources(sourceType, providers)).isEmpty()) continue;
            if (SetUtil.intersect(allSources, sources).isEmpty()) {
                sourcesByType.putAll((Object)sourceType, sources);
            } else if (!allSources.containsAll(sources)) {
                sources.removeAll(allSources);
                sourcesByType.putAll((Object)sourceType, sources);
            }
            allSources.addAll(sources);
        }
        return sourcesByType;
    }

    @NotNull
    private static Set<VirtualFile> getSources(@NotNull AndroidSourceType sourceType, @NotNull Iterable<IdeaSourceProvider> providers) {
        HashSet<VirtualFile> sources = new HashSet<VirtualFile>();
        for (IdeaSourceProvider provider : providers) {
            sources.addAll(sourceType.getSources(provider));
        }
        return sources;
    }

    @Nullable
    public Comparable getSortKey() {
        return this.getModule().getName();
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return String.format("%1$s (Android)", this.getModule().getName());
    }

    public void update(@NotNull PresentationData presentation) {
        super.update(presentation);
        presentation.setIcon(GradleUtil.getModuleIcon(this.getModule()));
    }

    public boolean equals(Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        return super.equals(o);
    }
}

