/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.psi.PsiDirectory;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidPsiDirectoryNode
extends PsiDirectoryNode {
    private final IdeaSourceProvider mySourceProvider;

    AndroidPsiDirectoryNode(@NotNull Project project, @NotNull PsiDirectory directory, @NotNull ViewSettings settings, @Nullable IdeaSourceProvider sourceProvider) {
        super(project, directory, settings);
        this.mySourceProvider = sourceProvider;
    }

    protected void updateImpl(@NotNull PresentationData data) {
        super.updateImpl(data);
        if (this.mySourceProvider != null && !"main".equals(this.mySourceProvider.getName())) {
            data.addText(data.getPresentableText(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            data.addText(" (" + this.mySourceProvider.getName() + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    @Nullable
    public Comparable getSortKey() {
        String sourceProviderName = this.mySourceProvider == null ? "" : this.mySourceProvider.getName();
        return this.getQualifiedNameSortKey() + "-" + ("main".equals(sourceProviderName) ? "" : sourceProviderName);
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        PsiDirectory value = (PsiDirectory)this.getValue();
        assert (value != null);
        return AndroidPsiDirectoryNode.toTestString(value.getName(), this.mySourceProvider);
    }

    @NotNull
    static String toTestString(@NotNull String element, @Nullable IdeaSourceProvider provider) {
        StringBuilder buffer = new StringBuilder(element);
        if (provider != null) {
            buffer.append(" (");
            buffer.append(provider.getName());
            buffer.append(")");
        }
        return buffer.toString();
    }
}

