/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.navigator.nodes.android.AndroidResComparator;
import com.google.common.base.Joiner;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidResFileNode
extends PsiFileNode
implements Comparable {
    private final AndroidFacet myFacet;

    AndroidResFileNode(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull ViewSettings settings, @NotNull AndroidFacet facet) {
        super(project, psiFile, settings);
        this.myFacet = facet;
    }

    public void update(@NotNull PresentationData data) {
        super.update(data);
        String text = data.getPresentableText();
        data.addText(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        data.setPresentableText(text);
        String qualifier = this.getQualifier();
        if (qualifier != null) {
            data.addText(qualifier, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        PsiFile psiFile = (PsiFile)this.getValue();
        assert (psiFile != null);
        String qualifier = this.getQualifier();
        return psiFile.getName() + (qualifier == null ? "" : qualifier);
    }

    @Nullable
    String getQualifier() {
        IdeaSourceProvider ideaSourceProvider;
        PsiFile resFile = (PsiFile)this.getValue();
        if (resFile == null) {
            return null;
        }
        PsiDirectory resTypeFolder = resFile.getParent();
        if (resTypeFolder == null) {
            return null;
        }
        String folderName = resTypeFolder.getName();
        int index = folderName.indexOf("-");
        String qualifier = index < 0 ? null : folderName.substring(index + 1);
        String providerName = null;
        PsiDirectory resFolder = resTypeFolder.getParent();
        if (resFolder != null && (ideaSourceProvider = this.findSourceProviderForResFolder(resFolder)) != null && "main".equals(providerName = ideaSourceProvider.getName())) {
            providerName = null;
        }
        if (qualifier == null && providerName == null) {
            return null;
        }
        return " (" + Joiner.on((String)", ").skipNulls().join((Object)qualifier, (Object)providerName, new Object[0]) + ')';
    }

    @Nullable
    public FolderConfiguration getFolderConfiguration() {
        PsiFile psiFile = (PsiFile)this.getValue();
        if (psiFile == null) {
            return null;
        }
        PsiDirectory folder = psiFile.getParent();
        return folder == null ? null : FolderConfiguration.getConfigForFolder((String)folder.getName());
    }

    @Nullable
    public Comparable getSortKey() {
        return this;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this;
    }

    public int compareTo(@NotNull Object obj) {
        return AndroidResComparator.INSTANCE.compare(this, obj);
    }

    @Nullable
    String getResName() {
        PsiFile f = (PsiFile)this.getValue();
        return f == null || !f.isValid() ? null : f.getName();
    }

    @Nullable
    private IdeaSourceProvider findSourceProviderForResFolder(@NotNull PsiDirectory resFolder) {
        for (IdeaSourceProvider provider : AndroidProjectViewPane.getSourceProviders(this.myFacet)) {
            if (!provider.getResDirectories().contains(resFolder.getVirtualFile())) continue;
            return provider;
        }
        return null;
    }
}

