/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.android.tools.idea.navigator.AndroidProjectTreeBuilder;
import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.navigator.nodes.FolderGroupNode;
import com.android.tools.idea.navigator.nodes.android.AndroidPsiDirectoryNode;
import com.android.tools.idea.navigator.nodes.android.AndroidPsiFileNode;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidSourceType;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSourceTypeNode
extends ProjectViewNode<AndroidFacet>
implements FolderGroupNode {
    @NotNull
    private final AndroidSourceType mySourceType;
    @NotNull
    private final Set<VirtualFile> mySourceRoots;
    @NotNull
    protected final AndroidProjectViewPane myProjectViewPane;

    AndroidSourceTypeNode(@NotNull Project project, @NotNull AndroidFacet androidFacet, @NotNull ViewSettings settings, @NotNull AndroidSourceType sourceType, @NotNull Set<VirtualFile> sources, @NotNull AndroidProjectViewPane projectViewPane) {
        super(project, (Object)androidFacet, settings);
        this.mySourceType = sourceType;
        this.mySourceRoots = sources;
        this.myProjectViewPane = projectViewPane;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        ArrayList<AbstractTreeNode> children = new ArrayList<AbstractTreeNode>();
        ProjectViewDirectoryHelper projectViewDirectoryHelper = ProjectViewDirectoryHelper.getInstance((Project)this.myProject);
        AndroidProjectTreeBuilder treeBuilder = (AndroidProjectTreeBuilder)this.myProjectViewPane.getTreeBuilder();
        for (PsiDirectory directory : this.getSourceFolders()) {
            Collection directoryChildren = projectViewDirectoryHelper.getDirectoryChildren(directory, this.getSettings(), true);
            children.addAll(this.annotateWithSourceProvider(directoryChildren));
            treeBuilder.createMapping(directory.getVirtualFile(), (AbstractTreeNode)this);
        }
        return children;
    }

    @NotNull
    private Collection<AbstractTreeNode> annotateWithSourceProvider(@NotNull Collection<AbstractTreeNode> folderChildren) {
        ArrayList<AbstractTreeNode> children = new ArrayList<AbstractTreeNode>(folderChildren.size());
        assert (this.myProject != null);
        for (AbstractTreeNode child : folderChildren) {
            if (child instanceof PsiDirectoryNode) {
                PsiDirectory folder = (PsiDirectory)((PsiDirectoryNode)child).getValue();
                assert (folder != null);
                children.add((AbstractTreeNode)new AndroidPsiDirectoryNode(this.myProject, folder, this.getSettings(), this.findSourceProvider(folder.getVirtualFile())));
                continue;
            }
            if (child instanceof PsiFileNode) {
                PsiFile file = (PsiFile)((PsiFileNode)child).getValue();
                assert (file != null);
                VirtualFile virtualFile = file.getVirtualFile();
                children.add((AbstractTreeNode)new AndroidPsiFileNode(this.myProject, file, this.getSettings(), this.findSourceProvider(virtualFile)));
                continue;
            }
            children.add(child);
        }
        return children;
    }

    @Nullable
    private IdeaSourceProvider findSourceProvider(@NotNull VirtualFile virtualFile) {
        AndroidFacet androidFacet = (AndroidFacet)((Object)this.getValue());
        assert (androidFacet != null);
        for (IdeaSourceProvider provider : AndroidProjectViewPane.getSourceProviders(androidFacet)) {
            if (!provider.containsFile(virtualFile)) continue;
            return provider;
        }
        return null;
    }

    @NotNull
    protected List<PsiDirectory> getSourceFolders() {
        assert (this.myProject != null);
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        ArrayList<PsiDirectory> folders = new ArrayList<PsiDirectory>(this.mySourceRoots.size());
        for (VirtualFile root : this.mySourceRoots) {
            PsiDirectory folder;
            if (!root.isValid() || (folder = psiManager.findDirectory(root)) == null) continue;
            folders.add(folder);
        }
        return folders;
    }

    protected void update(PresentationData presentation) {
        presentation.addText(this.mySourceType.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        Icon icon = this.mySourceType.getIcon();
        if (icon != null) {
            presentation.setIcon(icon);
        }
        presentation.setPresentableText(this.mySourceType.getName());
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return this.mySourceType.getName();
    }

    public boolean contains(@NotNull VirtualFile file) {
        for (VirtualFile root : this.mySourceRoots) {
            if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Comparable getSortKey() {
        return this.mySourceType;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.mySourceType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AndroidSourceTypeNode that = (AndroidSourceTypeNode)o;
        if (this.mySourceType != that.mySourceType) {
            return false;
        }
        return this.mySourceRoots.equals(that.mySourceRoots);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.mySourceType.hashCode();
        for (VirtualFile root : this.mySourceRoots) {
            result = 31 * result + root.hashCode();
        }
        return result;
    }

    @Override
    @NotNull
    public PsiDirectory[] getFolders() {
        List<PsiDirectory> folders = this.getSourceFolders();
        return folders.toArray(new PsiDirectory[folders.size()]);
    }
}

