/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.navigator.nodes.FolderGroupNode;
import com.android.tools.idea.navigator.nodes.android.AndroidModuleNode;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidTestsNode
extends ProjectViewNode<AndroidFacet>
implements FolderGroupNode {
    private static final String ANDROID_TESTS = "androidTests";
    private final AndroidProjectViewPane myProjectViewPane;

    AndroidTestsNode(@NotNull Project project, @NotNull AndroidFacet androidFacet, @NotNull ViewSettings settings, @NotNull AndroidProjectViewPane projectViewPane) {
        super(project, (Object)androidFacet, settings);
        this.myProjectViewPane = projectViewPane;
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        Module module = this.getModule();
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null || facet.getAndroidModel() == null) {
            return Collections.emptyList();
        }
        return AndroidModuleNode.getChildren(facet, this.getSettings(), this.myProjectViewPane, IdeaSourceProvider.getCurrentTestSourceProviders(facet));
    }

    public boolean contains(@NotNull VirtualFile file) {
        Module module = this.getModule();
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null || facet.getAndroidModel() == null) {
            return false;
        }
        for (IdeaSourceProvider provider : IdeaSourceProvider.getCurrentTestSourceProviders(facet)) {
            if (!provider.containsFile(file)) continue;
            return true;
        }
        return false;
    }

    public void update(@NotNull PresentationData presentation) {
        presentation.setPresentableText(ANDROID_TESTS);
        presentation.addText(ANDROID_TESTS, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        presentation.setIcon(ModuleType.get((Module)this.getModule()).getIcon());
    }

    @NotNull
    private Module getModule() {
        return this.getAndroidFacet().getModule();
    }

    @NotNull
    private AndroidFacet getAndroidFacet() {
        AndroidFacet facet = (AndroidFacet)((Object)this.getValue());
        assert (facet != null);
        return facet;
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return ANDROID_TESTS;
    }

    public boolean equals(Object object) {
        return object instanceof AndroidTestsNode && super.equals(object);
    }

    @Override
    @NotNull
    public PsiDirectory[] getFolders() {
        return PsiDirectory.EMPTY_ARRAY;
    }
}

